/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#define _USE_MATH_DEFINES
#include "layoutimagepainter.h"
#include "layoutimagepainterwhitetransparent.h"
#include "layoutimage.h"
#include "math.h"
#include <ft2build.h>
#include FT_FREETYPE_H

layoutImagePainterWhiteTransparent::layoutImagePainterWhiteTransparent(layoutImage *im):layoutImagePainterTransparent(im){
}


void layoutImagePainterWhiteTransparent::drawPolygon(pointArray *p,uint c){
  if (*paintAbort) return;
  color=c;
  fillStyle=0;
  in=p;
  if (convert())
  for (int i=0;i<(int)outSize-1;i++){
        drawLine(out.point(i),out.point(i+1));
		//printf("line: %d , %d / %d , %d\n",out.point(i).x(),out.point(i).y(),out.point(i+1).x(),out.point(i+1).y());
	}
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}


void layoutImagePainterWhiteTransparent::drawPolygon(pointArray *p,uint c, uint style){
  if (style==0) drawPolygon(p,c);
  else {
	if (*paintAbort) return;
	//fill->fill(0);
  	color=c;
  	fillStyle=style;
	dir = true;
  	in=p;
  	if (convertFill()){
	int i;
	//printf("draw line\n");
  	for (i=0;i<(int)outSize-1;i++){
        	drawLineFill(out.point(i),out.point(i+1));
	}
	if (!dir) 
		fill->scanLine(out.point(i).y())[out.point(i).x()]++;
	//printf("fill\n");
	//printf("ist %d %d %d %d\n",maxX,minX,maxY,minY);
	//printf("soll %d %d %d %d\n",pmaxX,pminX,pmaxY,pminY);
	int line=fill->bytesPerLine ();
	uchar *c = fill->scanLine(pminY) +pminX;
	uint *ptr = reinterpret_cast<uint *>(image->scanLine(pminY)) + pminX;
	int fillLength=pmaxX-pminX+1;
	switch (style){
	case 1: //Dense7Pattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 2: //Dense6Pattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 3: //Dense 3/16=19%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==3)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 4: //Dense 4/16=25%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==3)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==1)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 5: //Dense 5/16=31%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%4==1)||((x%4==3)))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 6: //Dense5Pattern 37%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2==1)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 7: //Dense4-5Pattern 7/16=44%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2==0)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2==1)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 8: //Dense4Pattern 50%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			if (y%2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2!=0)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2!=1)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 9: //solid
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			for (int x=pminX;x<=pmaxX;x++){
				b+= (*c);
				(*c)=0;
				if (b%2) *ptr&=color;
				ptr++;
				c++;
			}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
//10: horizontal 1:3<br>
	case 10: 
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 11: // FDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+1)%4);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%4==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 12: // FDiagPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+1)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 13: // FDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(((y+1)/2)%4);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 14: // VerPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==1)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 15: // BDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=3-(((y+1)/2)%4);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 16: // BDiagPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=4-((y+1)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 17: // BDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=4-((y+1)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%5==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 18: // CrossPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+3)%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==3)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 19: // DiagCrossPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+3)%5);
			short h2=4-((y+2)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==h)||(x%5==h2))) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
// 20: horizontal 1:7<br>
	case 20: 
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 21: // FDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%8==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 22: // FDiagPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 23: // FDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y/2)%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 24: // VerPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==0)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 25: // BDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=7-((y/2)%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 26: // BDiagPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=7-(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 27: // BDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=7-(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%8==h)) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 28: // CrossPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr&=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==0)) *ptr&=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 29: // DiagCrossPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			short h2=7-(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%8==h)||(x%8==h2))) *ptr&=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 30:
			for (int y=pminY;y<=pmaxY;y++){// | o
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6<3)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==3)||(x%6==5))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 31: 
		for (int y=pminY;y<=pmaxY;y++){// | |
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}		
		break;
	case 32: 
		for (int y=pminY;y<=pmaxY;y++){// - -
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6<3)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6>2)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 33: 
		for (int y=pminY;y<=pmaxY;y++){// -|
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6>2)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 34: 
		for (int y=pminY;y<=pmaxY;y++){// \/
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==0)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==5)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==3)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 35: 
		for (int y=pminY;y<=pmaxY;y++){// +/
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==0)||(x%6==2)||(x%6==1))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==3)||(x%6==5)||(x%6==4))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 36: 
		for (int y=pminY;y<=pmaxY;y++){// o/
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==0)||(x%6==2))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==3)||(x%6==5))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 37: 
		for (int y=pminY;y<=pmaxY;y++){//o
	 	   	short b=0;
			short h=(y%5);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==0)||(x%5==2))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 38: 
		for (int y=pminY;y<=pmaxY;y++){//X
	 	   	short b=0;
			short h=(y%5);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==0)||(x%5==2))) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==1)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==0)||(x%5==2))) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 39: 
		for (int y=pminY;y<=pmaxY;y++){//cross
	 	   	short b=0;
			short h=(y%5);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5!=0)&&(x%5!=4)) *ptr&=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==2)) *ptr&=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	default: //
		for (int y=pminY;y<=pmaxY;y++){
			for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					c++;
				}
		c+=line-fillLength;
		}
		break;
	}}
        //printf("end\n");
	LImage->imageChanged=true;
  }
  if (elementDraw) drawElement();
}

void layoutImagePainterWhiteTransparent::drawPoint(QPoint po,uint color){
// cross for seelcted text elements
  QPoint p2=drawTrans.mapDraw(po);
  if (p2.x()<minX+3) return;
  if (p2.x()>maxX-3) return;
  if (p2.y()<minY+3) return;
  if (p2.y()>maxY-3) return;
  uint *ptr = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
  *ptr&=color;
  uint *p;
  p=ptr;
  ptr-=w+1;
  *ptr&=color;
  uint *p1;
  p1=ptr+2;
  *p1&=color;
  ptr-=w+1;
  p1=ptr+4;
  *p1&=color;
  *ptr&=color;
  ptr-=w+1;
  *ptr&=color;
  ptr+=6;
  *ptr&=color;
  ptr=p+w-1;
  *ptr&=color;
  p1=ptr+2;
  *p1&=color;
  ptr+=w-1;
  *ptr&=color;
  p1=ptr+4;
  *p1&=color;
  ptr+=w-1;
  *ptr&=color;
  p1=ptr+6;
  *p1&=color;
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}

void layoutImagePainterWhiteTransparent::drawPixel(QPoint po,uint color){
  QPoint p2=drawTrans.mapDraw(po);
  if (p2.x()<minX) return;
  if (p2.x()>maxX) return;
  if (p2.y()<minY) return;
  if (p2.y()>maxY) return;

  uint *ptr = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
  *ptr&=color;
  if (elementDraw) drawElement();
  LImage->imageChanged=true;

}


void layoutImagePainterWhiteTransparent::drawImage(QImage i,int x ,int y){
	int startx,stoppx,offx;
	int starty,stoppy,offy;
	startx=x;
	stoppx=x+i.width();
	starty=y;
	stoppy=y+i.height();
	offx=x;
	offy=y;
	if (startx<1){ startx=1;}
	if (starty<1){ starty=1;}
    if (stoppx>w){ stoppx=w;}
	if (stoppy>h){ stoppy=h;}
	//printf("-- %d %d\n",x,y);
	//printf("x %d %d %d\n",startx,stoppx,offx);
	//printf("y %d %d %d\n",starty,stoppy,offy);
	for (int ny=starty;ny<stoppy;ny++){
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(ny)) +startx;
		uint *ptri = reinterpret_cast<uint *>(i.scanLine(ny-offy)) +startx-offx;
		for (int nx=startx;nx<stoppx;nx++){
			if (*ptri!=LImage->backgroundColor){
				*ptr&=*ptri;
			}
			ptr++;
			ptri++;
		}
	}
LImage->imageChanged=true;

}

void layoutImagePainterWhiteTransparent::drawFTBitmap(FT_Bitmap *b,int x ,int y,uint color){
	int startx,stoppx,offx;
	int starty,stoppy,offy;
	startx=x;
	stoppx=x+b->width;
	starty=y;
	stoppy=y+b->rows;
	offx=x;
	offy=y;
	//printf("-- %d %d\n",x,y);
	//printf("x %d %d %d\n",startx,stoppx,offx);
	//printf("y %d %d %d\n",starty,stoppy,offy);
	//printf("pitch %d width %d\n",b->pitch,b->width);
	//printf("mode %d\n",b->pixel_mode);
	//if (FT_PIXEL_MODE_MONO==b->pixel_mode)printf("mono %d\n",b->pitch);
	if (startx<1){ startx=1;}
	if (starty<1){ starty=1;}
    if (stoppx>w){ stoppx=w;}
	if (stoppy>h){ stoppy=h;}
    
	for (int ny=starty;ny<stoppy;ny++){
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(ny)) +startx;
		unsigned char *ptrb =b->buffer+(ny-offy)*b->pitch+((startx-offx)>>3);
		unsigned char comp;
		comp=128;
		for (int nx=startx;nx<stoppx;nx++){
			//printf("-- %d %d %d\n",(*ptrb),comp,nx);
			if ((*ptrb)&(comp)) *ptr&=color;
			ptr++;
			if (comp==1) {
				comp=128;
				ptrb++;
			}
			else comp=comp>>1;
		// b->pitch;
		// b->buffer;

		}
	}
LImage->imageChanged=true;
}
/*
void layoutImagePainterTransparent::drawLine(QPoint p1, QPoint p2,uint c){
  // nur fr senkrechte und waagereichte linien
  color=c;
  drawLine(limit(p1),limit(p2));
  
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}*/

void layoutImagePainterWhiteTransparent::drawLine(QPoint p1, QPoint p2)
{
/*	{QPainter pa(image);
	//pa.begin(image);
	 pa.setPen(color);
	pa.setRenderHint(QPainter::Antialiasing);
	pa.drawLine(p1,p2);}
return;*/
  QPoint delta=p2-p1;
  if (delta.x()==0) {  
	if (delta.y()==0) {
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
		*ptr&=color;
		return;
		}
	//senkrecht
 	if (p1.x()==0) return;
 	if (p1.x()==maxX) return; 
  	if (p1.y()>p2.y()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
 	 uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p1.x();
  	for (;ptr<=end;ptr+=w){
		*ptr &= color;
		}
 	}
  else if (delta.y()==0) { //waagerecht
 	if (p1.y()==0) return;
 	if (p1.y()==maxY) return; 
 	 if (p1.x()>p2.x()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
  	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
 	 for (;ptr<=end;ptr++){
		*ptr &= color;
		}
 	}
  else if (abs(delta.x())>=abs(delta.y())){ //leichte steigung
 	float off=(float)delta.y()/(delta.x());
 	if (p1.x()>p2.x()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
 	
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr++){
			*ptr &= color;
			d+=off;
			if (d>=0.5) {ptr+=w;d-=1;}
			}
		*ptr &= color;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr++){
			*ptr &= color;
			d+=off;
			if (d<=-0.5) {ptr-=w;d+=1;}
			}
		*ptr &= color;
		}
 	}
  else  {// starke steigung
  	float off=(float)delta.x()/(delta.y());
 	if (p1.y()>p2.y()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
 	
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr+=w){
			*ptr &= color;
			d+=off;
			if (d>=0.5) {ptr++;d-=1;}
			}
		*ptr &= color;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr+=w){
			*ptr &= color;
			d+=off;
			if (d<=-0.5) {ptr--;d+=1;}
			}
		*ptr &= color;
		}
	}
}

void layoutImagePainterWhiteTransparent::drawLineFill(QPoint p1, QPoint p2)
{
/*	{QPainter pa(image);
	//pa.begin(image);
	 pa.setPen(color);
	pa.setRenderHint(QPainter::Antialiasing);
	pa.drawLine(p1,p2);}
	//pa.end();*/
  QPoint delta=p2-p1;
  if (delta.x()==0) {  
	if (delta.y()==0) {
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
		*ptr&=color;
		return;}
	//senkrecht
	bool newDir=false;
	if (p1.y()>p2.y()) newDir=true; 
	if (newDir==dir) 
		fill->scanLine(p1.y())[p1.x()]++;
	else 
		dir=newDir;
	
 	if (p1.x()==maxX) return; 
  	if (p1.y()>p2.y()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
	uchar *c = fill->scanLine(p1.y()) + p1.x();
	int line=fill->bytesPerLine ();
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p1.x();
  	for (;ptr<=end;ptr+=w){
		*ptr &= color;
		(*c) ++;
		c+=line;
		}
 	}
  else if (delta.y()==0) { //waagerecht
 	if (p1.y()==0) return;
 	if (p1.y()==maxY) return; 
 	 if (p1.x()>p2.x()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
  	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
 	 for (;ptr<=end;ptr++){
		*ptr &= color;
		}
 	}
  else if (abs(delta.x())>=abs(delta.y())){ //leichte steigung
 	float off=(float)(delta.y())/(delta.x());
	bool newDir=false;
	if (p1.y()>p2.y()) newDir=true; 
	if (newDir==dir) 
		fill->scanLine(p1.y())[p1.x()]++;
	else 
		dir=newDir;
 	
	if (p1.x()>p2.x()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
	int line=fill->bytesPerLine ();
 	uchar *c = fill->scanLine(p1.y()) + p1.x();
	(*c)++;
	c++;
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	//float g=0;
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr++){
			//printf("1: off %f g %f ptr %d end %d dx %d dy %d\n",off,g,ptr,end,delta.x(),delta.y());
			*ptr &= color;
			d+=off;
			//g+=off;
			if (d>=0.5) {ptr+=w;d-=1;c+=line;(*c)++;}
			c++;
			}
		*ptr &= color;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr++){
			//printf("2: off %f g %f ptr %d end %d dx %d dy %d\n",off,g,ptr,end,delta.x(),delta.y());
			*ptr &= color;
			d+=off;
			//g+=off;
			if (d<=-0.5) {ptr-=w;d+=1;c-=line;(*c)++;}
			c++;
			}
		*ptr &= color;
		}
	/*uint *pa = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *pe = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	*pe=color*256;
	*pa=color*256;*/
 	}
  else  {// starke steigung
	bool newDir=false;
	if (p1.y()>p2.y()) newDir=true; 
	if (newDir==dir) 
		fill->scanLine(p1.y())[p1.x()]++;
	else 
		dir=newDir;
  	float off=(float)delta.x()/(delta.y());
 	if (p1.y()>p2.y()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
 	int line=fill->bytesPerLine ();
 	uchar *c = fill->scanLine(p1.y()) + p1.x();
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr+=w){
			*ptr &= color;
			(*c)++;
			d+=off;
			if (d>=0.5) {ptr++;d-=1;c++;}
			c+=line;
			}
		*ptr &= color;
		(*c)++;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr+=w){
			*ptr &= color;
			(*c)++;
			d+=off;
			if (d<=-0.5) {ptr--;d+=1;c--;}
			c+=line;
			}
		*ptr &= color;
		(*c)++;
		}
	/*uint *pa = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *pe = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	*pe=color*256*256;
	*pa=color*256*256;*/
 	}

}

/*
void layoutImagePainterTransparent::drawGrid(int gridX,int gridY,int gridOffsetX, int gridOffsetY){
 if (w==0) return;
 if (h==0) return;
 QPoint p=drawTrans.mapDraw(QPoint(0,0));
 QMatrix matrixinv=drawTrans.matrix.inverted();
 QPoint p1=(raster(matrixinv.map(QPoint(0,0)),gridX,gridY,gridOffsetX,gridOffsetY));
 QPoint p2=(matrixinv.map(QPoint(w,h)));
 QPoint p3=drawTrans.mapDraw(QPoint(gridX,gridY))-p;
 //painter->setPen(setup::gridColor);
 int c=setup::gridColor.rgb();
 int c1=QColor((setup::zeroColor.red()+setup::gridColor.red())/2,(setup::zeroColor.green()+setup::gridColor.green())/2,(setup::zeroColor.blue()+setup::gridColor.blue())/2).rgb();
 int c2=QColor((setup::zeroColor.red()+3*setup::gridColor.red())/4,(setup::zeroColor.green()+3*setup::gridColor.green())/4,(setup::zeroColor.blue()+3*setup::gridColor.blue())/4).rgb();
 if ((p3.x()>7)&&(p3.y()<(-7))){
 	for (int x=p1.x();x<p2.x();x+=gridX){
 		for (int y=p1.y();y>p2.y();y-=gridY){
			QPoint p=drawTrans.mapDraw(QPoint(x,y));
			if ((p.x()>=0)&&(p.x()<w))
				if ((p.y()>=0)&&(p.y()<h)) {
			//painter->drawPoint(drawTrans.matrix.map(QPoint(x,y)));
			if ((((x/gridX)%10)==0)&&(((y/gridY)%10==0)))
				image->setPixel(p.x(),p.y(),c1);
			else if ((((x/gridX)%5)==0)&&(((y/gridY)%5==0)))
				image->setPixel(p.x(),p.y(),c2);
			else
			image->setPixel(p.x(),p.y(),c);
		
			}
		}
 	}
 }
 c=setup::zeroColor.rgb();
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(1,1);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(-2,0);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(0,-2);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(2,0);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);

}
*/
/*
void layoutImagePainterTransparent::drawText(QString s, int width,  QPoint point, strans trans,uint color){

	
 if (currentFontNum!=fontNum) 
	{	
		initFace(); 
		if (currentFontNum!=fontNum) return; 
	}

 double gr=(1.25*(double)width);
 double a=(double)(trans.angle+drawTrans.angle)/180*M_PI;
 if (!(trans.mirror_x^drawTrans.mirror_x)) a=(double)(trans.angle-drawTrans.angle)/180*M_PI;
 // if (!(e->drawTrans.mirror_x))a=-a;
  
  FT_Matrix     matrixA;
  matrixA.xx = (FT_Fixed)( cos( a ) * 0x10000L );
  matrixA.xy = (FT_Fixed)(-sin( a ) * 0x10000L );
  matrixA.yx = (FT_Fixed)( sin( a ) * 0x10000L );
  matrixA.yy = (FT_Fixed)( cos( a ) * 0x10000L );
  if ((trans.mirror_x)^ (!drawTrans.mirror_x)) {  // 
		matrixA.yy = -matrixA.yy;
		matrixA.yx = -matrixA.yx;
		}
 
  FT_Vector     pen; 
  pen.x = 0;
  pen.y = 0;
  
	int error = FT_Set_Pixel_Sizes(
            face,   // handle to face object 
            0,      // pixel_width           
            (int)gr);   // pixel_height          

  FT_GlyphSlot  slot = face->glyph;  // a small shortcut 
  int           pen_x, pen_y, n;


  FT_Set_Transform( face, &matrixA, &pen );

  QPoint p=drawTrans.mapDraw(point);
  pen_x = p.x();
  pen_y = p.y();

  for ( n = 0; n < s.length();n++ )
  {
    FT_UInt  glyph_index;

    // retrieve glyph index from character code 
    glyph_index = FT_Get_Char_Index( face,(FT_ULong) s[n].unicode() );

    // load glyph image into the slot (erase previous one) 
    error = FT_Load_Glyph( face, glyph_index, FT_LOAD_NO_HINTING+FT_LOAD_MONOCHROME);
    if ( error )
      continue;  //ignore errors 

    // convert to an anti-aliased bitmap 

    error = FT_Render_Glyph( face->glyph, FT_RENDER_MODE_MONO );

    if ( error )
      continue;

    // now, draw to our target surface 
	drawFTBitmap(&slot->bitmap,pen_x + slot->bitmap_left, pen_y - slot->bitmap_top, color);

    // increment pen position 
    pen_x += (slot->advance.x >> 6);

   pen_y -= (slot->advance.y >> 6); 
  }

    //FT_Matrix     matrix;  
    matrixA.xx = 0x10000L;
    matrixA.xy = 0;
    matrixA.yx = 0;
    matrixA.yy = 0x10000L;
    //FT_Vector     pen; 
    pen.x = 0;
    pen.y = 0;
    FT_Set_Transform( face, &matrixA, &pen );
//printf("dt-end\n");
}*/
