/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAYERS_H
#define LAYERS_H
#include "layer.h"
#include <qobject.h>
class drawingField;
/*
@author Juergen Thies
*/


#define layersMax 1024
// also change layersmax in sip file
#define datatypeMax 256
//!  Layer display setup class. 
/*!
  This class is the global setup for the display of all layers. Each layer is identified by a number between 0 and 255. The setup of a single layer can setup by the static public attribute num.
@code
layers::num[5].name="Layer Number 5";
@endcode
The class layers can not be used as type.
@see @link "Class layer"
*/
class layers: public QObject{
Q_OBJECT
public:
//! displayed Layers
/*!
 sets the maximum layers accessable in the userinterface (mainmenu and layer toolbar)
*/
static int displayedLayers;
//!setup for a single layer
/*!
 Each layer can setup separately via the class layer. The layer-class can be accessed by this array.
@see @link "Class layer"
 Use 'number instead in the python interface.
*/
static layer num[layersMax];
static uint layerColor[layersMax];//autogenerated
static void calLayerColor();
static layer* number(int i){return &num[i];}
    layers();

    ~layers();
//!finding a layer
/*!
 Use this function to find the number of a layer. 
\param layerName name of the wanted layer
\return number of the layer if found, -1 if layerName is not found
*/    
static int findLayer(QString layerName);
static void writeLayerMacro(int startLayer,int stopLayer,QString fileName);
static void write3dSetupMacro(QString fileName);
//! show all layers
/*!
 makes all layer visible
*/
static void showAllLayer(){
	for (int i=0;i<layersMax;i++)
		num[i].visible=true;}
//! hide all layers
/*!
 makes all layer invisible
*/
static void hideAllLayer(){for (int i=0;i<layersMax;i++)
		num[i].visible=false;}
//! enable all layers
/*!
 makes all layers enable
*/
static void enableAllLayer(){
	for (int i=0;i<layersMax;i++)
		num[i].enable();}
//! disable all layers
/*!
 makes all layers disable
*/
static void disableAllLayer(){
	for (int i=0;i<layersMax;i++)
		num[i].disable();}
//! reset 3d view
/*!
 The 3D view of all layers is reset and turned off.
*/
static void reset3dView(){
	for (int i=0;i<layersMax;i++)
		num[i].set3dView(0,0);}
//! layer max
/*!
 @return the number of layers in the LayoutEditor is returned.
*/
static int layerMax(){return layersMax;}
static void checkLayer();
static int maxLevel();
static int findLevel(int i);
static int globalVia();
static QList<int> viaLevels();
static QList<int> conductorLayers();
static void generateLayerMap();
static void generateLayerAutoMap(drawingField *);
static int mapLayer(int layer,int datatype);
static int bestColor(QColor);
static int bestColorUsed(QColor);
static int unusedLayer();
//! disable unused layers
/*!
Disables all layers not used in the current design 
*/ 
static void disableUnusedLayers(drawingField *d);
//! hide unused layers
/*!
Hide all layers not used in the current design 
*/ 
static void hideUnusedLayers(drawingField *d);
//! hide current unused layers
/*!
Hide all layers not used in the current cell
*/ 
static void hideCurrentUnusedLayers(drawingField *d);
private:
static short layerMap[layersMax][datatypeMax+1];
};
#endif
