/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LAYERPROPERTIES_H
#define LAYERPROPERTIES_H

#include "ui_layerpropertiesdialog.h"

#include <qpainter.h>
#include <qpixmap.h>
#include <qbrush.h>
#include <qpen.h>
#include "widgets/layersetupbutton.h"
#include <QDialog>
#include "layer.h"
#include "widgets/shortkeybutton.h"

class layerproperties : public QDialog, public Ui::layerpropertiesdialog
{
  Q_OBJECT
public:
  layersetupbutton *b[layerStyle];
public:
  layerproperties();
  ~layerproperties();
  //layerproperties(int brushStyle,QPen p, QString name, QString sk);
  layerproperties(int layerNum);
  /*$PUBLIC_FUNCTIONS$*/
  int brushStyle;
  QBrush brush;
  QPen pen;
  QPixmap pixmap;
  int layer_;
  bool allVisible;
  bool enabled;
public slots:
  /*$PUBLIC_SLOTS$*/
  
  
protected:
  /*$PROTECTED_FUNCTIONS$*/
  
protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
  void changeStyle(int bs);
  void setPixmap();
  void changeColor();
  void displayAll();
  void disableClicked();
  
};

#endif

