/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "layerproperties.h"
#include "setup.h"
#include "widgets/layersetupbutton.h"
#include <qcolordialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>
//Added by qt3to4:
#include <QPixmap>
using namespace Ui;

layerproperties::layerproperties()
: layerpropertiesdialog()
{setupUi(this);
setModal(true);
layer_=-1;
}

layerproperties::~layerproperties()
{
for (int i=0;i<layerStyle;i++){
	delete b[i];
	}

}
 
// layerproperties::layerproperties(int bs, QPen p,QString name, QString sk)
layerproperties::layerproperties(int layerNum)
: layerpropertiesdialog()
{setupUi(this);
 layer_=layerNum;
 layerName->setText(layers::num[layerNum].name);
 brushStyle=layers::num[layerNum].brushStyle;
 brush=layer::getBrush(brushStyle);
 pen=layers::num[layerNum].pen;
 brush.setColor(pen.color());
 setPixmap();
 for (int i=0;i<layerStyle;i++){
 	b[i]= new layersetupbutton(i,Ui_layerpropertiesdialog::style);
	int k,j;
	j=0;
	k=i*25; while (k>180+50) {k-=250;j+=25;}
 	b[i]->setGeometry(5+k,20+j,25,25);
	connect(b[i],SIGNAL(pressed2(int)),this,SLOT(changeStyle(int)));
 }

 connect(color,SIGNAL(clicked()),this,SLOT(changeColor()));
 shortKeyB->setShortKey(layers::num[layerNum].shortkey);
 allVisible=false;
 connect(fullDisplay,SIGNAL( clicked()),this,SLOT(displayAll()));
 level3d->setValue(layers::num[layerNum].level3d);
 thickness3d->setValue(layers::num[layerNum].thickness3d);
 mapLayer->setValue(layers::num[layerNum].mapToLayer);
 mapDatatype->setValue(layers::num[layerNum].mapToDatatype);
 if (layers::num[layerNum].use==false) enableDisableButton->setText(tr("enable layer"));
 enableDisableButton->hide();
 mapping->hide();
 setting3d->hide();
 resize(width(),400);
 connect(enableDisableButton,SIGNAL(clicked()),this,SLOT(disableClicked()));
 enabled=layers::num[layerNum].use;
}

void layerproperties::disableClicked(){
 enabled=!enabled;
 if (enabled)  enableDisableButton->setText(tr("disable layer"));
   else  enableDisableButton->setText(tr("enable layer"));
}

void layerproperties::displayAll(){
  allVisible=true;
  fullDisplay->hide();
  enableDisableButton->show();
  mapping->show();
  setting3d->show();
  resize(width(),height()+170);
}

void layerproperties::changeColor(){
 QColor color=QColorDialog::getColor(pen.color());
  if (color.isValid()){
  	pen.setColor(color);
  	brush.setColor(color);
  	setPixmap();}
}


/*$SPECIALIZATION$*/
void layerproperties::reject()
{
  QDialog::reject();
}

void layerproperties::accept()
{

  if (allVisible){
    layers::num[layer_].use=enabled;
    layers::num[layer_].level3d=level3d->value();
    layers::num[layer_].thickness3d=thickness3d->value();
    layers::num[layer_].mapToLayer=mapLayer->value();
    layers::num[layer_].mapToDatatype=mapDatatype->value();
  }
  QDialog::accept();
}

void layerproperties::setPixmap(){
pixmap=QPixmap(100,100);
QPainter p(&pixmap);
pixmap.fill(setup::backgroundColor);
p.setBrush(brush);
p.setPen(pen);
p.drawRect(10,10,80,80);
color->setIcon(QIcon(pixmap));
}

void layerproperties::changeStyle(int bs){
brushStyle=bs;
brush=layer::getBrush(bs);
brush.setColor(pen.color());
setPixmap();
}
