/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAYER_H
#define LAYER_H
#include <qstring.h>
#include <qpen.h>
#include <qbrush.h>
#include "widgets/shortkey.h"
#define layerStyle 40


/**
@author Juergen Thies
*/
enum layerTypesType {layerTypeUnknown, layerTypeVia,layerTypeConductor};
//!  Layer display setup class. 
/*!
  This class is the setup for the display of one layer. Each layer can accessed via the class layers.
@code
layers::num[5].name="Layer Number 5";
@endcode
The class layer can not be used as type.
@see @link "Class layers"
*/
class layer: private shortKey
{
public:
//!layerName
/*!
 The name of a layer is hold here.
*/  
   QString name;
   QPen pen;
   int brushStyle;
   static QBrush getBrush(int i);
   QBrush brush(){
	   QBrush br=getBrush(brushStyle);
	   br.setColor(pen.color());
	   return br;
   };
//!visibility of a layer
/*!
 The visibility of a layer can modified via this value.
*/  
   bool visible;
   int level3d;
   int thickness3d;
//!setup 3D view
/*!
The height level and the thickness of the layer ist set.
*/
   void set3dView(int level,int thickness){level3d=level;thickness3d=thickness;} 
   bool use;
//!layer enable
/*!
 The layer will be enabled and be displayed in the menus/toolbars.
*/
   void enable(){use=true;visible=true;}
//!visibility of a layer
/*!
 The layer will be disabled and not be displayed in the menus/toolbars.
*/
   void disable(){use=false;visible=false;};


    layer();

    ~layer();
 //!color of a layer
/*!
 The color of a layer can modified via method.
 @param red	the red component 
 @param green	the green component 
 @param blue	the blue component 
*/  
   void setColor(int red, int green, int blue);
//!set style of a layer
/*!
 The style/filling of a layer can modified via this method.
 @param style	0: NoBrush<br>1: dense 7%<br>2: dense 13%<br>3: dense 19%<br>4: dense 25%<br>5: dense 31%<br>6: dense 37%<br>7: dense 44%<br>8: dense 50%<br>9: solid<br>10: horizontal small<br>11: 27&deg; small<br>12: 45&deg; small<br>13: 72&deg; small<br>14: vertical small<br>15: 72&deg; back small<br>16: 45&deg; back small<br>17: 27&deg; back small<br>18: cross small<br>19: diagcross small<br>20: horizontal <br>21: 27&deg; <br>22: 45&deg; <br>23: 72&deg; <br>24: vertical<br>25: 72&deg; back<br>26: 45&deg; back<br>27: 27&deg; back<br>28: cross<br>29: diagcross<br>
*/ 
   void setStyle(int style);
//!style of a layer
/*!
 The style/filling of a layer can read via this method.
 @return style 
 see above for details on available styles
*/ 
   int getStyle();
//! layer shortkey
/*!
 shortkey for this layer used in the layer-shortkey functions.
*/ 
   QString shortkey;
//! Map to Layer
/*!
 If the option "gds map layer" or "oasis map layer" is active, the layer is mapped to this value.
*/ 
int mapToLayer;
//! Map to Datatype
/*!
 If the option "gds map layer" or "oasis map layer" is active, the layer is mapped to this datatype. If datatype is <0, all load datatypes are mapped and saved with datatype 0
*/ 
int mapToDatatype;
//! is enabled
/*!
@return true, if the layer is enabled.
*/ 
bool isEnabled();
   int getMapToDatatype(int datatype){if (mapToDatatype<0) return datatype; return mapToDatatype;}
   int getShortkeyKey();
   Qt::KeyboardModifiers getShortkeyModifiers();
   layerTypesType layerType;
   QList<int> typeParameter;
   void setType(layerTypesType);
   void setType(int type);
   int getType();
   void setTypeParameter(int i,int value);
   int getTypeParameter(int i);
};

#endif
