/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ERRORREPORT_H
#define ERRORREPORT_H

#include <qobject.h>
#include <qstring.h>
#include "reportitem.h"

/**
@author Juergen Thies
*/
class errorreport : public QObject
{
Q_OBJECT
private:
QString title;
QString report;
reportitem *items;
static QString lastReport;
static int lastRang;
public:
    errorreport(QObject *parent = 0, const char *name = 0);

    ~errorreport();

void setTitle(const QString &titel_);
void addItem(const QString &type, int rang, const QString &value=QString::null);
void generateReport();
QString getReport();
void showReport();     
static void showLastReport();
static int getLastRang();   
static QString getLastRangString();  
static QString getLastReport(){return lastReport;};
};


#endif
