/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEWRITE_H
#define FILEWRITE_H

#include <qfile.h>
#include <QString>
#include <zlib.h>
#define bufferSize 256000
/**
@author Juergen Thies
*/
class fileWrite : public QFile
{
public:
    fileWrite(QString filename);
    
    ~fileWrite();
    bool open();
    void close();
    

    void writeUInt16(quint16 i);
    void writeUInt8(quint8 i);
    void writeInt16(qint16 i);
    void writeInt32(qint32 i);
    void writeString(QString s, int size);
   
private:
 bool noswap;
 void writeBuffer();
 char buffer[bufferSize+1];
 int bufferPos;
 bool compress;
 bool compressinit;
 z_stream_s zlib;
 char zlibBuf[16*2048];
};

#endif
