/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEGENERAL_H
#define FILEGENERAL_H

#include <qobject.h>
#include "general/errorreport.h"
#include "general/drawingfield.h"

/**
@author Juergen Thies
*/

enum fileOpenType {fileOpen,fileImport,fileUpdate};

class filegeneral : public QObject
{
Q_OBJECT
public:
    filegeneral(QObject *parent = 0, const char *name = 0);

    ~filegeneral();
    static void import(errorreport *report, drawingField *d, cellList *celll);
    static void update(errorreport *report, drawingField *d, cellList *celll);
    static void fitDifferentDatabaseunits(errorreport *report, drawingField *d, double databaseunithelp);
    static void resolveBrockenCellrefs(errorreport *report, drawingField *d, cellList *celll, fileOpenType ftype);
};

#endif
