/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEREAD_H
#define FILEREAD_H

#include <qfile.h>
#define bufferSize 256000
/**
@author Juergen Thies
*/
class fileRead : public QFile
{
public:
    fileRead(QString filename);
    
    ~fileRead();
    bool open();
    bool end;

    qint16 readInt16();
    quint16 readUInt16();
    quint8 readUInt8();
    qint8 readInt8();
    qint32 readInt32();
private:
 bool noswap;
 bool lastBlock;
 void readBuffer();
 char buffer[bufferSize+1];
 int bufferPos,bufferRead;

};

#endif
