/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TEXT_H
#define TEXT_H

#include "element.h"
#include <qstring.h>
//Added by qt3to4:
#include "pointarray.h"
#include <QTextStream>
#include "strans.h"
#include "general/textrender.h"
#include <ft2build.h>
#include FT_FREETYPE_H

/**
@author Juergen Thies
*/
class oasis;
class txt : public element
{
public:
   QString name;
   QPoint point;
   strans trans;
   int width;
   int presentation;
    txt();
    txt(int layer,QPoint p,QString s);
    txt(txt *t){name=t->name;point=t->point;layerNum=t->layerNum;trans=t->trans;width=t->width;presentation=t->presentation;
		property=t->property;
		datatype=t->datatype;
}
    ~txt();
   virtual QString getName(){return name;}
   virtual void setName(QString n) {name=n;}
   virtual void paint(layoutImagePainter *e);
   virtual void paintSelect(layoutImagePainter *e);
   virtual void paintSelected(layoutImagePainter *e);
   virtual void paintNode(int node, layoutImagePainter *e);
   virtual void paintHighlighted(QPainter *,strans  ) ;
   virtual void paintHighlighted(QPainter *,strans ,QPoint ) ;
   virtual void paintInfo(QPoint *,QPoint *,uint *)const;
   virtual bool isText() const{return true;}
   virtual void fSelect(QRect select);
   virtual void pSelect(QRect select);
   virtual void fDeselect(QRect select);
   virtual void pDeselect(QRect select);
   virtual void fAllSelect(QRect select);
   virtual void fAllDeselect(QRect select);
   virtual void minimum(QPoint *pos);
   virtual void maximum(QPoint *pos);
   virtual void minimumSelect(QPoint *pos);
   virtual void maximumSelect(QPoint *pos);
   virtual int minSize() {return width;}
   virtual void saveSOURCE( source *);
   virtual void saveGDS(gds *);
   virtual void saveDXF(dxf *);
   virtual void saveSVG(svg *);
   virtual void saveOASIS( oasis *);
   virtual void saveCIF( cif *);
   virtual void saveGerber( gerber *);
   virtual void saveODB( odb *);
   virtual void saveEPS(eps *);
   virtual int saveEPSCount();
   virtual void saveSelect(QDataStream *);
   virtual void save(QDataStream *);
   virtual void moveSelect(QPoint pos);
   virtual void move(QPoint pos);
   virtual txt* getText(){return this;};
   virtual void setMirrorx();
   virtual void clearMirrorx();
   virtual void toggleMirrorx(); 
   virtual void rotate(double); 
   virtual void scale(double); 
   virtual void setTrans(strans t){trans=t;}
   virtual double nearestDistance(QPoint);
   virtual double nearestDistance(const QPoint,QPoint *)const;
   virtual bool showProperties(elementList *, drawingField *,bool basicEditing);
   virtual void setWidth(int w){width=w;};
   virtual int getWidth(){return width;};
   virtual bool correct(){if (name.isEmpty()) {return false;} return true;}
   virtual void clean();
   virtual void setPresentation(int p){presentation=p;}
   virtual void map(strans m);
   virtual void mapSelect(strans m);
   virtual void resize(double size);
   virtual elementList * convertText();
   virtual void selectAll(){select=true;}
   virtual void selectVisible(){if (layers::num[layerNum].visible){select=true;}}
   virtual void deselectAll(){select=false;}
   virtual void selectLayer(int layer){if (layerNum==layer) selectAll();}
   virtual void deselectLayer(int layer){if (layerNum==layer) deselectAll();}
   virtual void countSelect(elementCount *c){if (select) {c->text++;} }
   virtual bool useLayer(int layer){if (layerNum==layer) return true; else return false;}
   virtual void useLayer(QBitArray *b){b->setBit(layerNum);};
   virtual pointArray getPoints(){pointArray p; p.resize(1); p.setPoint(0,point); return p;}
   virtual bool identical(element *);
   virtual bool identicalStructure(element *);
   virtual bool replaceText(QString s1,QString s2) {if (s1!=name)return false; name=s2; return true;}
   virtual bool pointOnLayer(QPoint p,int layer){if ((layerNum==layer)&&(p==point))return true; return false;}
   virtual void roundSelect(int grid){point=round(point,grid);}
   /*virtual bool drcOnGrid(int grid,int layer){if (layerNum!=layer) return true;
						if (round(point,grid)==point) return true;
						return false;}*/
   friend bool operator% (const txt &r1,const txt &r2);
   friend bool operator== (const txt &r1,const txt &r2);
   static textRender render;
};
/*
class textRender {
public:

static bool init();
static bool available();
static QList<pointArray> renderText(QString s, int width, int presentation, QPoint point, strans trans );
static void render(QString s, int width, QPoint point, strans trans,layoutImagePainter *e,uint color);
private:
static bool initDone;
static FT_Library library;
static FT_Face face;
static void bezier2(double px0, double py0,double px1, double py1,double px2, double py2,int depth, pointArray *a, int maxDepth);
static void bezier3(double px0, double py0,double px1, double py1,double px2, double py2,double px3, double py3,int depth, pointArray *a,int maxDepth);
};
*/
#endif
