/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "cellrefarrayproperties.h"
#include <qspinbox.h>
#include <qlineedit.h>
#include "general/setup.h"
#include <qradiobutton.h>
#include <qstring.h>
#include "cellrefarray.h"
#include <qcheckbox.h>
#include <qvalidator.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include "general/userunitsvalidator.h"
#include "propertyedit.h"
#include "general/drawingfield.h"

cellrefarrayproperties::cellrefarrayproperties(drawingField *d)
: cellrefarraypropertiesdialog()
{setupUi(this);
drawing=d;
userunits=d->userunits;
userunitsValidator v(d->userunits,this);
decimals=v.decimals();
mag->setValidator(new QDoubleValidator(0.000001,1000000000,6,mag));
angle->setValidator(new QDoubleValidator(0,360,3,angle));
connect(mag,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(angle,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
orginX->setValidator(new userunitsValidator(userunits,orginX));
orginY->setValidator(new userunitsValidator(userunits,orginY));
stepXX->setValidator(new userunitsValidator(userunits,stepXX));
stepXY->setValidator(new userunitsValidator(userunits,stepXY));
stepYX->setValidator(new userunitsValidator(userunits,stepYX));
stepYY->setValidator(new userunitsValidator(userunits,stepYY));
connect(mag,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(angle,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(orginX,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(orginY,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(stepXX,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(stepXY,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(stepYX,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(stepYY,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(flat,SIGNAL( clicked()),this,SLOT(DoneFlat()));
connect(deleteCell,SIGNAL( clicked()),this,SLOT(DoneDeleteCell()));
connect(attributeButton,SIGNAL(clicked()),this,SLOT(showAttributes()));
connect(fullDisplay,SIGNAL( clicked()),this,SLOT(displayAll()));
setModal(true);
}

cellrefarrayproperties::~cellrefarrayproperties()
{
}

/*$SPECIALIZATION$*/
void cellrefarrayproperties::reject()
{
  QDialog::reject();
}

void cellrefarrayproperties::accept()
{
  updateElement();
  QDialog::accept();
 
}

void cellrefarrayproperties:: updateElement(){
 if (cellname->currentText()!=element->cell_ref->cellName){
		cell *c=drawing->findCell(cellname->currentText());
		if (c!=NULL)element->cell_ref=c;
		}
  //element->cell_ref->cellName=cellname->text();
  strans t;
  t.reset();
  t.scale(mag->text().toDouble());
  t.rotate(-angle->text().toDouble());
  if (mirror_x->isChecked()){t.toggleMirror_x();}
  element->trans=t;
  element->anz_x=anzX->value();
  element->anz_y=anzY->value();
  element->point=QPoint(element::round(orginX->text().toDouble()/userunits),element::round(orginY->text().toDouble()/userunits));
  element->space_x=QPoint(element::round(stepXX->text().toDouble()/userunits),element::round(stepXY->text().toDouble()/userunits));
  element->space_y=QPoint(element::round(stepYX->text().toDouble()/userunits),element::round(stepYY->text().toDouble()/userunits));
}

void cellrefarrayproperties::setElement(cellrefArray *p){
   element=p;
   cellname->clear();
   QStringList sl=drawing->undependendCells();
   sl.sort();
   cellname->addItems(sl);
   int pos=cellname->findText(p->cell_ref->cellName);
   if (pos>=0) cellname->setCurrentIndex(pos);
   //cellname->setText(p->cell_ref->cellName);
   QString s;
   s.setNum(p->trans.mag,'g',6);
   mag->setText(s);
   s.setNum(p->trans.angle,'g',6);
   angle->setText(s);
   if (p->trans.mirror_x){mirror_x->setChecked(true);}
   else {mirror_x->setChecked(false);}
   anzX->setValue(p->anz_x);
   anzY->setValue(p->anz_y);
   s.setNum((double)(p->point.x())*userunits,'f',decimals);
   orginX->setText(s);
   s.setNum((double)(p->point.y())*userunits,'f',decimals);
   orginY->setText(s);
   s.setNum((double)(p->space_x.x())*userunits,'f',decimals);
   stepXX->setText(s);
   s.setNum((double)(p->space_x.y())*userunits,'f',decimals);
   stepXY->setText(s);
   s.setNum((double)(p->space_y.x())*userunits,'f',decimals);
   stepYX->setText(s);
   s.setNum((double)(p->space_y.y())*userunits,'f',decimals);
   stepYY->setText(s);
   OK->setFocus();
   if (element->property.size()==0) attributeButton->hide();
   else fullDisplay->hide();
}

 void cellrefarrayproperties::displayAll(){
fullDisplay->hide();
attributeButton->show();
}



void cellrefarrayproperties::checkInput(const QString &){
QString s;
s=mag->text();
bool b=true;
int i=0;
if (mag->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=angle->text();
if (angle->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=orginX->text();
if (orginX->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=orginY->text();
if (orginY->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=stepXX->text();
if (stepXX->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=stepXY->text();
if (stepXY->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=stepYX->text();
if (stepYX->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=stepYY->text();
if (stepYY->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
OK->setEnabled(b);
}



void cellrefarrayproperties::showAttributes(){
propertyEdit pe(&element->property);
pe.exec();
}



