/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlineedit.h>
#include <qvalidator.h>
#include "sizeadjust.h"
#include "general/userunitsvalidator.h"
#include "elements/element.h"

sizeadjust::sizeadjust(double )
: sizeadjustDialog()
{
setupUi(this);
connect(asym,SIGNAL(clicked()),this,SLOT(setAsymmetric()));
val->setValue(1);
setModal(true);
}

sizeadjust::~sizeadjust()
{
}

void sizeadjust::setAsymmetric(){
stack->setCurrentIndex(1);
double d=val->value();
valueX->setValue(d);
valueY->setValue(d);
}


/*$SPECIALIZATION$*/
bool sizeadjust::dialog(double uunits, int *valx, int *valy){
   sizeadjust d(uunits);
    d.show();
    int i=d.exec();
    d.hide();
    switch (i) {
    case QDialog::Rejected :
    	return false;
    case QDialog::Accepted :
	if (d.stack->currentIndex()==1){
	*valx=element::runden(d.valueX->value()/uunits);
	*valy=element::runden(d.valueY->value()/uunits);
	}
	else {
		*valx=element::runden(d.val->value()/uunits);
		*valy=element::runden(d.val->value()/uunits);	
	}
	return true;
   }
  return false;
}




