/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "selectcell.h"
#include <QModelIndex>
#include <QHeaderView>
#include "elements/celllist.h"
#include "elements/cell.h"

selectCell::selectCell(drawingField *d)
: selectCellDialog()
{
    setupUi(this);
    listCells.clear();
    cellMap.clear();
#ifdef printtime
 // setup::centralTimer.start();
#endif
    QHash<cell*,bool> list;
    cellList *e=d->firstCell;
    while (e!=NULL){
	if (e->thisCell!=NULL){
		e->thisCell->marker=true;
		list[e->thisCell]=true;
		QString s=e->thisCell->cellName;
		cellMap[e->thisCell->cellName]=e->thisCell;
		listCells.append(s);
		e->thisCell->listDepend();
		}
    	e=e->next_cell;
    }
  for (e=d->firstCell;e!=NULL;e=e->nextCell){
     e->thisCell->removeDepend(&list);
  }
  for (e=d->firstCell;e!=NULL;e=e->nextCell){
     e->thisCell->marker=list.value(e->thisCell,true);
  }
  //  for (e=d->firstCell;e!=NULL;e=e->nextCell) if (e->thisCell!=NULL)
   //  if(e->thisCell->marker) e->thisCell->unmarkDepend(d->firstCell);
    listCells.sort();
    bool showAllCell=true;
    if (listCells.size()>25) showAllCell=false;
    model = new QStandardItemModel();
    QModelIndex parent;
    parent = model->index(0, 0, parent);
    model->insertColumns(0, 1,parent);
    QStringList::const_iterator i;
    for (i = listCells.constBegin(); i != listCells.constEnd(); ++i)
    	if (cellMap.value((*i))->marker==true) addCell(&parent,(*i),-1,d);  //topcell
		else if (showAllCell) addCell(&parent,(*i),0,d); // no topcell
    cellTree->setModel(model);
    QHeaderView *h=cellTree->header();
    h->setVisible(false);
    setModal(true);
    QItemSelectionModel *sm=cellTree->selectionModel();
    QModelIndex current;
    current=model->indexFromItem(model->findItems(d->currentCell->cellName).at(0));
    sm->select(current,QItemSelectionModel::Select);
//printf("selectCell: %d ms\n", setup::centralTimer.elapsed());
    for (e=d->firstCell;e!=NULL;e=e->nextCell){
        e->thisCell->markerList.clear();
	e->thisCell->markerInt.clear();
  }
}

void selectCell::addCell(QModelIndex *parent, QString name,int num,drawingField *d, int level){
 if (level>10) return;
        model->insertRow(model->rowCount(*parent), *parent);
        QModelIndex index = model->index(model->rowCount(*parent)-1, 0, *parent);
		model->setData(index, name,Qt::WhatsThisRole);
		QString s;
		s.setNum(num);
		if (num==-1) 
			model->setData(index, name+"  (*)",Qt::DisplayRole);
		else if (num>1) 
		 model->setData(index, name+"  ("+s+")",Qt::DisplayRole);
		else
	     model->setData(index, name,Qt::DisplayRole);
        model->insertColumn(0, index);
        int i;
	QString moreCells=tr("and more ...");
	if (name==moreCells) return;
	int limit=20000;
	switch (level) {
        case 0: limit=10000;
		break;
	case 1: limit=1000;
		break;
	case 2: limit=500;
		break;
	case 3: limit=100;
		break;
	case 4: limit=30;
		break;
	case 5: limit=20;
		break;
	case 6: limit=10;
		break;
	case 7:
	case 8: limit=5;
		break;
	default: limit =2;
	}
        class cell *c=cellMap.value(name,NULL);//=d->findCell(name);
	int size=c->markerList.size();
        if (c!=NULL) for (i = 0; i < size; i++) {
    	         if (i<limit) addCell(&index,c->markerList[i],c->markerInt[i],d,level+1);
		 else if (i==limit) {
			addCell(&index,moreCells,c->markerList.size()-i,d,level+1);
			}
		 else i=size;
		}
}



selectCell::~selectCell()
{
delete model;
}

void selectCell::accept()
{ 

  result=model->data(cellTree->selectionModel ()->currentIndex (),Qt::WhatsThisRole).toString();
  //printf("%s\n",result.ascii());
  QDialog::accept();
}


