/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlineedit.h>
#include <qvalidator.h>
#include "pointentry.h"
#include "general/userunitsvalidator.h"
#include "general/drawingfield.h"
#include "elements/element.h"

pointEntry::pointEntry(double uunits,QWidget* )
: pointEntryDialog()
{
setupUi(this);
userunitsValidator *u=new userunitsValidator(uunits,xEnter);
decimals=u->decimals();
xEnter->setValidator(u);
yEnter->setValidator(new userunitsValidator(uunits,yEnter));
uUnits=uunits;
//moveX->setValidator(new QDoubleValidator(-1000000000,1000000000,6,moveX));
//moveY->setValidator(new QDoubleValidator(-1000000000,1000000000,6,moveY));
setModal(true);
}

pointEntry::~pointEntry()
{
}

void pointEntry::setPoint(QPoint p){
  QString s;
   s.setNum((double)(p.x())*uUnits,'f',decimals);
   xEnter->setText(s);
   s.setNum((double)(p.y())*uUnits,'f',decimals);
   yEnter->setText(s);
}

QPoint pointEntry::getPoint(){
return QPoint(element::round(xEnter->text().toDouble()/uUnits),element::round(yEnter->text().toDouble()/uUnits));
}

bool pointEntry::editPoint(drawingField *d, QPoint *p){
	pointEntry pe(d->userunits,d);
	pe.setPoint(*p);
	pe.show();
	switch (pe.exec()){
	case QDialog::Accepted:
		*p=pe.getPoint();
		return true;
		break;
	case QDialog::Rejected: return false;
	};
return false;
}


