/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "layersetupwidget2.h"
#include <QString>
#include <QWidget>
#include <QLayout>
#include "general/layers.h"
#include "general/layer.h"
#include "general/setup.h"
layerSetupWidget2::layerSetupWidget2(QWidget* , int layerN )
: layerSetupWidget()
{
  setupUi(this);
 layerNum=layerN;
  setup();
  connect (layerEnable,SIGNAL(clicked()),this,SLOT(setEnabled()));
  connect (layerName,SIGNAL(entered()),this,SLOT(trigEnter()));
}

layerSetupWidget2::~layerSetupWidget2()
{

}
 
void layerSetupWidget2::trigEnter(){
  emit entered(layerNum);
}
 
void layerSetupWidget2::setup(){
  QString s;
  s.setNum(layerNum);
  layerNumber->setText(s);
  layerName->setText(layers::num[layerNum].name);
  layerEnable->setChecked(layers::num[layerNum].use);
  setEnabled();
  //shortKeyB->setShortKey(layers::num[layerNum].shortkey);
  shortKey=layers::num[layerNum].shortkey;
  mapLayer->setMaximum(layersMax-1);
  mapLayer->setValue(layers::num[layerNum].mapToLayer);
  mapDatatype->setMaximum(datatypeMax-1);
  mapDatatype->setValue(layers::num[layerNum].mapToDatatype);
  color=layers::num[layerNum].pen.color();
  level=layers::num[layerNum].level3d;
  thickness=layers::num[layerNum].thickness3d;
  brushStyle=layers::num[layerNum].brushStyle;
#ifdef Q_OS_MAC
  setMaximumSize(10000,30);
  setMinimumSize(100,30);
#endif
}

void layerSetupWidget2::save(){
  bool b=layerEnable->isChecked();
 if (b!=layers::num[layerNum].use){
	if (b) layers::num[layerNum].enable();
	else layers::num[layerNum].disable();
	}
  layers::num[layerNum].name=layerName->text();
  layers::num[layerNum].shortkey=shortKey; //B->getShortKey();
  layers::num[layerNum].mapToLayer=mapLayer->value();
  layers::num[layerNum].mapToDatatype=mapDatatype->value();
  layers::num[layerNum].setColor(color.red(),color.green(),color.blue());
  layers::num[layerNum].level3d=level;
  layers::num[layerNum].thickness3d=thickness;
  layers::num[layerNum].brushStyle=brushStyle;
}

void layerSetupWidget2::setEnabled(){
  bool b=layerEnable->isChecked();
  layerName->setEnabled(b);
//  shortKeyB->setEnabled(b);
  if ((setup::gdsMapLayer==false)&&(setup::oasisMapLayer==false)) b=false;
  mapLayer->setEnabled(b);
  mapDatatype->setEnabled(b);

}


void layerSetupWidget2::setEnabled(bool b){
  layerEnable->setChecked(b);
  setEnabled();
}
