/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "cellselect.h"
#include <QModelIndex>
#include <QHeaderView>
#include "elements/celllist.h"
#include "elements/cell.h"

cellSelect::cellSelect(QStringList d)
: cellSelectDialog()
{
    setupUi(this);
    cells->clear();
    cells->addItems(d);
    cells->setSortingEnabled(true);
}



cellSelect::~cellSelect()
{
//delete model;
}

void cellSelect::accept()
{ 

  //result=model->data(cellTree->selectionModel ()->currentIndex (),Qt::WhatsThisRole).toString();
  //printf("%s\n",result.ascii());
  QDialog::accept();
}

QStringList cellSelect::getCells(QStringList sl){
    cellSelect d(sl);
    d.show();
    int i=d.exec();
    d.hide();
    switch (i) {
    case QDialog::Rejected :
    	return QStringList();
    case QDialog::Accepted :
        sl.clear();
	QList<QListWidgetItem *> l=d.cells->selectedItems();
	for (int i=0;i<l.size();i++){
	  sl<<l.at(i)->text();
	}
        return sl;
   }
  return QStringList();
}
