<?php

// Determine what locale to use
switch (PHP_OS)
{
	case 'WINNT':
	case 'WIN32':
		$locale = 'portuguese-brazil';
		break;

	case 'FreeBSD':
	case 'NetBSD':
	case 'OpenBSD':
		$locale = 'pt_BR.ISO8859-1';
		break;

	default:
		$locale = 'pt_BR';
		break;
}

// Attempt to set the locale
setlocale(LC_CTYPE, $locale);

// Language definitions for frequently used strings
$lang_common = array(

// Text orientation and encoding
'lang_direction'		=>	'ltr',	// ltr (Left-To-Right) or rtl (Right-To-Left)
'lang_encoding'			=>	'iso-8859-1',
'lang_multibyte'		=>	false,

// Notices
'Bad request'			=>	'Requisio invlida. O link acessado est incorreto ou no existe mais.',
'No view'				=>	'Voc no possui permisso para ver esses fruns.',
'No permission'			=>	'Voc no possui permisso para acessar esta pgina.',
'Bad referrer'			=>	'HTTP_REFERER invlido. Voc foi direcionado para esta pgina atravs de uma fonte no autorizada. Se o problema persistir, verifique se a \'URL Base\' est configurada corretamente em Administrao / Opes e que voc est acessando o frum atravs daquela URL. Mais informaes a respeito da verificao da fonte (referrer) pode ser encontrada na documentao do PunBB.',

// Topic/forum indicators
'New icon'				=>	'No existem novos tpicos',
'Normal icon'			=>	'<!-- -->',
'Closed icon'			=>	'Este tpico est fechado',
'Redirect icon'			=>	'Frum redirecionado',

// Miscellaneous
'Announcement'			=>	'Aviso',
'Options'				=>	'Opes',
'Actions'				=>	'Aes',
'Submit'				=>	'Enviar',	// "name" of submit buttons
'Ban message'			=>	'Voc est banido deste frum.',
'Ban message 2'			=>	'O banimento expira em ',
'Ban message 3'			=>	'O administrador ou moderador que te baniu deixou a seguinte mensagem:',
'Ban message 4'			=>	'Por favor, envie suas dvidas para o administrador do frum em',
'Never'					=>	'Nunca',
'Today'					=>	'Hoje',
'Yesterday'				=>	'Ontem',
'Info'					=>	'Info',		// a common table header
'Go back'				=>	'Voltar',
'Maintenance'			=>	'Manuteno',
'Redirecting'			=>	'Redirecionando',
'Click redirect'		=>	'Clique aqui caso seu navegador no redirecione automaticamente',
'on'					=>	'ativado',		// as in "BBCode is on"
'off'					=>	'desativado',
'Invalid e-mail'		=>	'O email que voc digitou  invlido.',
'required field'		=>	' um campo de preenchimento obrigatrio.',	// for javascript form validation
'Last post'				=>	'ltimo post',
'by'					=>	'por',	// as in last post by someuser
'New posts'				=>	'Novos&nbsp;posts',	// the link that leads to the first new post (use &nbsp; for spaces)
'New posts info'		=>	'Ir para o primeiro post novo deste tpico.',	// the popup text for new posts links
'Username'				=>	'Usurio',
'Password'				=>	'Senha',
'E-mail'				=>	'E-mail',
'Send e-mail'			=>	'Enviar e-mail',
'Moderated by'			=>	'Moderado por',
'Registered'			=>	'Cadastrado',
'Subject'				=>	'Assunto',
'Message'				=>	'Mensagem',
'Topic'					=>	'Tpico',
'Forum'					=>	'Frum',
'Posts'					=>	'Posts',
'Replies'				=>	'Respostas',
'Author'				=>	'Autor',
'Pages'					=>	'Pginas',
'BBCode'				=>	'BBCode',	// You probably shouldn't change this
'img tag'				=>	'tag [img]',
'Smilies'				=>	'Smilies',
'and'					=>	'e',
'Image link'			=>	'imagem',	// This is displayed (i.e. <image>) instead of images when "Show images" is disabled in the profile
'wrote'					=>	'escreveu',	// For [quote]'s
'Code'					=>	'Cdigo',		// For [code]'s
'Mailer'				=>	'Mailer',	// As in "MyForums Mailer" in the signature of outgoing e-mails
'Important information'	=>	'Informao importante',
'Write message legend'	=>	'Escreva sua mensagem e envie',

// Title
'Title'					=>	'Ttulo',
'Member'				=>	'Membro',	// Default title
'Moderator'				=>	'Moderador',
'Administrator'			=>	'Administrador',
'Banned'				=>	'Banido',
'Guest'					=>	'Visitante',

// Stuff for include/parser.php
'BBCode error'			=>	'A sintaxe do BBCode na mensagem est incorreta.',
'BBCode error 1'		=>	'Est faltando a tag inicial para [/quote].',
'BBCode error 2'		=>	'Est faltando a tag final para [code].',
'BBCode error 3'		=>	'Est faltando a tag inicial para [/code].',
'BBCode error 4'		=>	'Esto faltando uma ou mais tags finais para [quote].',
'BBCode error 5'		=>	'Esto faltando uma ou mais tags iniciais para [/quote].',

// Stuff for the navigator (top of every page)
'Index'					=>	'ndice',
'User list'				=>	'Lista de usurios',
'Rules'					=>  'Regras',
'Search'				=>  'Busca',
'Register'				=>  'Cadastro',
'Login'					=>  'Login',
'Not logged in'			=>  'Voc no est logado.',
'Profile'				=>	'Perfil',
'Logout'				=>	'Sair',
'Logged in as'			=>	'Logado como',
'Admin'					=>	'Administrao',
'Last visit'			=>	'ltima visita',
'Show new posts'		=>	'Exibir novos posts desde a ltima visita',
'Mark all as read'		=>	'Marcar todos os tpicos como lidos',
'Link separator'		=>	'',	// The text that separates links in the navigator

// Stuff for the page footer
'Board footer'			=>	'Rodap do frum',
'Search links'			=>	'Links de busca',
'Show recent posts'		=>	'Exibir posts recentes',
'Show unanswered posts'	=>	'Exibir posts sem resposta',
'Show your posts'		=>	'Exibir os seus posts',
'Show subscriptions'	=>	'Exibir os tpicos em que voc est inscrito',
'Jump to'				=>	'Ir para',
'Go'					=>	' Ir ',		// submit button in forum jump
'Move topic'			=>  'Mover tpico',
'Open topic'			=>  'Abrir tpico',
'Close topic'			=>  'Fechar tpico',
'Unstick topic'			=>  'Desfixar tpico',
'Stick topic'			=>  'Fixar tpico',
'Moderate forum'		=>	'Moderar frum',
'Delete posts'			=>	'Excluir mltiplos posts',
'Debug table'			=>	'Informaes de debug',

// For extern.php RSS feed
'RSS Desc Active'		=>	'Os tpicos mais ativos recentemente em',	// board_title will be appended to this string
'RSS Desc New'			=>	'Os tpicos mais novos em',					// board_title will be appended to this string
'Posted'				=>	'Publicado'	// The date/time a topic was started

);
