#include <stdio.h>
#include "konto_check.h"

int main(int argc,char **argv)
{
   char blz[16],kto[16],buffer[256],*name,*ort,*retval_txt;
   int retval,r1,plz;
   FILE *in,*out;

   if(argc<2)return 1;
   if(!(in=fopen(argv[1],"r")))return 2;
   if(!(out=fopen(argv[2],"w")))return 3;

   if((retval=lut_init("blz.lut2",5,0))!=OK){  /*\a {\commentfont\hypertarget{beispiel.funktion.c.lutinit}{}Bibliothek %
                                                 \href{#funktion.c.lutinit}{initialisieren}} */
         /*\a {\commentfont\hypertarget{beispiel.funktion.c.ktocheckretval2html}{}%
             \href{#funktion.c.ktocheckretval2html}{Rckgabewert} als \href{#rueckgabewerte}{Klartext} ausgeben} */
      fprintf(stderr,"lut_init: %s\n",kto_check_retval2txt(retval));
      return 4;
   }

   while(!feof(in)){
      fgets(buffer,256,in); /* Datei zeilenweise einlesen */
      if(sscanf(buffer,"%s %s",blz,kto)<2 || feof(in))continue;
      retval=kto_check_blz(blz,kto);            /*\a {\commentfont\hypertarget{beispiel.funktion.c.ktocheckblz}{} %
                                                   Bankverbindung \href{#funktion.c.ktocheckblz}{testen}} */
      retval_txt=kto_check_retval2txt(retval);  /*\a {\commentfont\hypertarget{beispiel.funktion.c.ktocheckretval2html}{}%
             \href{#funktion.c.ktocheckretval2html}{Rckgabewert} als \href{#rueckgabewerte}{Klartext} ausgeben} */
      name=lut_name(blz,0,NULL);                /*\a {\commentfont\hypertarget{beispiel.funktion.c.lutname}{}\href{#funktion.c.lutname}{Banknamen} holen} */
      plz=lut_plz(blz,0,NULL);                  /*\a {\commentfont\hypertarget{beispiel.funktion.c.lutplz}{}\href{#funktion.c.lutplz}{PLZ} holen} */
      ort=lut_ort(blz,0,NULL);                  /*\a {\commentfont\hypertarget{beispiel.funktion.c.lutort}{}\href{#funktion.c.lutort}{Ort} holen} */
      if(retval>=OK)
         fprintf(out,"%s %s: %s; %s, %d %s\n",blz,kto,retval_txt,name,plz,ort);
      else
         fprintf(out,"%s %s: %s\n",blz,kto,retval_txt);
   }
   lut_cleanup(); /*\a {\commentfont\hypertarget{beispiel.funktion.c.lutcleanup}{}%
                    Speicher wieder \href{#funktion.c.lutcleanup}{freigeben}} */
}
