/***************************************************************************
                             ModelCanvas.h
                             -------------------
    begin                : Sat April 5, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#ifndef _MODELCANVAS_H_
#define _MODELCANVAS_H_

#include "CodeObjects.h"
#include <wx/scrolwin.h>

class CKlassModelerView;

class CModelCanvas : public wxScrolledWindow
{
public:
	CModelCanvas( CKlassModelerView *pView, wxFrame *pParent );
	virtual					~CModelCanvas();
	void					Detach(){ m_pView = NULL; }
	void					EnableGrid( bool bUseGrid );
	virtual void			OnDraw( wxDC &DC );
	void					DrawSection( wxDC &DC, wxPoint Offset, wxRect Section );
	void					GetModelDimensions( wxRect &BoundingRect );
	void					GetPageSize( int &Width, int &Height );
	void					ComputeSizes();
	bool					GenerateJPGImage( string FileName, int FileType );
	wxFont					GetViewFont(){ return m_ViewFont; }
#ifdef __MXMSW__
	void					OnContextMenu( wxContextMenuEvent &Event ){ ShowContextMenu(ScreenToClient(Event.GetPosition())); }
#else
	void					OnRightButtonUp( wxMouseEvent &Event ){ ShowContextMenu( Event.GetPosition() ); }
#endif
	void					OnLeftButtonDown( wxMouseEvent &Event );
	void					OnLeftButtonUp( wxMouseEvent &Event );
	void					OnLeftDoubleClick( wxMouseEvent &Event );
	void					OnMouseMove( wxMouseEvent &Event );
	DECLARE_EVENT_TABLE()
protected:
	void					ShowContextMenu( const wxPoint &Pos );
	void 					GetClassRect( wxDC *pDC, CClass *pClass, wxRect &SizeRect );
	CClass 					*GetClassAt( const wxPoint &Point );
	CInheritence			*GetInheritenceAt( const wxPoint &Point );
	void					OnNewClass( wxCommandEvent &Event );
	void					OnNewClassFromHeader( wxCommandEvent &Event );
	void					OnNewClassFromClipboard( wxCommandEvent &Event );
	void					OnZoomIn( wxCommandEvent &Event );
	void					OnZoomOut( wxCommandEvent &Event );
	void					OnDeleteClass( wxCommandEvent &Event );
	void					OnInheritFrom( wxCommandEvent &Event );
	void					OnHasA( wxCommandEvent &Event );
	void					OnUsesA( wxCommandEvent &Event );
	void					OnGenerateCode( wxCommandEvent &Event );
	void					DrawClass( wxDC *pDC, CClass *pClass, wxPoint &Offset, wxRect &Bounding );
	void					DrawInheritence( wxDC *DC, CClass *pChild, CInheritence *pInheritence, wxPoint &Offset, wxRect &Bounding );
	void					DrawRelation( wxDC *DC, CClass *pParent, CRelation *pRelation, wxPoint &Offset, wxRect &Bounding );
	void					Inherit( const wxPoint &Position );
	void					HasA( const wxPoint &Position );
	void					UsesA( const wxPoint &Position );
	CKlassModelerView		*m_pView;
	wxFont					m_ViewFont;
	float					m_Zoom;
	wxPoint					m_ContentsClickPosition;
	bool					m_LeftDrag;
	wxPoint					m_MouseMovePosition;
	CClass					*m_pDragClass;
	CClass					*m_pInheritenceChild;
	CInheritence			*m_pDragInheritence;
	CClass					*m_pHasAParent;
	CClass					*m_pUsesAParent;
	bool					m_bUseGrid; 
	int						m_PrinterPageWidth;
	int						m_PrinterPageHeight;
};

#endif
