/***************************************************************************
                             MainFrame.cpp
                             -------------------
    begin                : Thu April 3, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "MainFrame.h"
#include "KlassModelerView.h"
#include "KlassModelerApp.h"
#include "KlassModelerDoc.h"
#include "CodeObjectsDlg.h"
#include "ModelCanvas.h"
#include <string>

using namespace std;

#define CLASS_TREE			200
#define WINDOW_ID			201

BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(EVT_REBUILD_TREE, wxID_HIGHEST+1)
END_DECLARE_EVENT_TYPES()

DEFINE_EVENT_TYPE(EVT_REBUILD_TREE)

#define EVT_REBUILD_TREE_COMMAND(id, fn) \
    DECLARE_EVENT_TABLE_ENTRY( \
        EVT_REBUILD_TREE, id, -1, \
        (wxObjectEventFunction)(wxEventFunction)(wxCommandEventFunction)&fn, \
        (wxObject *) NULL \
    ),

IMPLEMENT_CLASS(CMainFrame,wxDocParentFrame)

BEGIN_EVENT_TABLE(CMainFrame,wxDocParentFrame)
    EVT_MENU( KLASSMODELER_ABOUT, CMainFrame::OnAbout )
    EVT_MENU( KLASSMODELER_CONTENTS, CMainFrame::OnContents )
	EVT_MENU( KM_GENERATE_CODE, CMainFrame::OnGenerateCode )
	EVT_MENU( KM_GENERATE_HTML, CMainFrame::OnGenerateHTML )
	EVT_TREE_ITEM_ACTIVATED(CLASS_TREE, CMainFrame::OnItemActivated)
	EVT_REBUILD_TREE_COMMAND(-1,CMainFrame::OnRebuildTree)
END_EVENT_TABLE()

CMainFrame::CMainFrame( wxDocManager *pDocManager, const wxString &Title, const wxSize &Size )
	: wxDocParentFrame( pDocManager, (wxFrame*)NULL, WINDOW_ID, Title, wxPoint(0,0), Size )
{
	m_pCurrentDoc = NULL;
}

CMainFrame::~CMainFrame()
{
	m_pCurrentDoc = NULL;
	m_pClassTree->DeleteAllItems();
}

bool CMainFrame::Init()
{
	m_pClassTree = new wxTreeCtrl( this, CLASS_TREE, wxDefaultPosition, wxDefaultSize, wxTR_DEFAULT_STYLE | wxSUNKEN_BORDER );
	m_pClassTree->Show( true );
#ifdef __WXGTK__
	wxFont	TreeFont( 9, wxDEFAULT, wxNORMAL, wxNORMAL );
	m_pClassTree->SetFont( TreeFont );
#endif

	return true;
}

void CMainFrame::OnAbout( wxCommandEvent& event )
{
	wxString	OutString;

	OutString = _T("KlassModeler\nVersion ");
	OutString += VERSION;
	OutString += _T("\n(c) 2001 by James Wells");
	wxMessageBox( OutString, _T("About...") );
}

void CMainFrame::OnContents( wxCommandEvent& event )
{
	wxString	OutString;

	OutString = _T("Please refer to the HTML help file found in the KlassModeler distribution at docs/index.html");
	wxMessageBox( OutString, _T("Help...") );
}

void CMainFrame::OnGenerateCode( wxCommandEvent& event )
{
	if( m_pCurrentDoc == NULL )
		return;
	bool				bSuccess;
	CKlassModelerView	*pView;

	SetCursor( *wxHOURGLASS_CURSOR );
	bSuccess = m_pCurrentDoc->GenerateCode();
	SetCursor( *wxSTANDARD_CURSOR );
	pView = (CKlassModelerView*)m_pCurrentDoc->GetFirstView();
	if( !bSuccess )
		wxMessageBox( _T("Error generating headers"), _T("Error") );
	else {
		wxString Output;
		Output = _T("headers enerated succesfully.  You can find them at ");
		Output += pView->GetDoc()->GetBasePath().c_str();
		wxMessageBox( Output, _T("Success") );
	}
}

void CMainFrame::OnGenerateHTML( wxCommandEvent& event )
{
	if( m_pCurrentDoc == NULL )
		return;
	CKlassModelerView	*pView;
	bool				bSuccess;

	// sort of a hack, won't work if we get into multiple
	// views.  But for now it's fine.
	SetCursor( *wxHOURGLASS_CURSOR );
	pView = (CKlassModelerView*)m_pCurrentDoc->GetFirstView();
	bSuccess = m_pCurrentDoc->GenerateHTML( pView->GetCanvas() );
	SetCursor( *wxSTANDARD_CURSOR );
	if( !bSuccess )
		wxMessageBox( _T("Error generating HTML"), _T("Error") );
	else {
		wxString Output;
		Output = _T("HTML Generated succesfully.  You can find them at ");
		Output += pView->GetDoc()->GetBasePath().c_str();
		wxMessageBox( Output, _T("Success") );
	}
}

void CMainFrame::DrawTree( CKlassModelerDoc *pDoc, bool bForceRefresh )
{
	if( m_pClassTree == NULL )
		return;
	if( (m_pCurrentDoc == pDoc) && !bForceRefresh )
		return;
	wxTreeItemId				Root;
	wxTreeItemId				Node;
	wxTreeItemId				ChildNode;
	ClassVector					*pClasses;
	ClassVector::iterator		itClasses;
	MethodVector				*pMethods;
	MethodVector::iterator		itMethods;
	VariableVector				*pVariables;
	VariableVector::iterator	itVariables;
	CTreeNode					*pNodeData;

	m_pCurrentDoc = pDoc;
	m_pClassTree->DeleteAllItems();
	if( m_pCurrentDoc == NULL )
		return;
	if( m_pCurrentDoc->GetFilename() == "" )
		Root = m_pClassTree->AddRoot( _T("New File") );
	else
		Root = m_pClassTree->AddRoot( m_pCurrentDoc->GetFilename() );
	pClasses = m_pCurrentDoc->GetClassVector();
	for( itClasses=pClasses->begin(); itClasses!=pClasses->end(); ++itClasses ){
		Node = m_pClassTree->InsertItem( Root, 0, wxString((wxChar*)(*itClasses)->GetName().c_str()) );
		pNodeData = new CTreeNode( *itClasses );
		m_pClassTree->SetItemData( Node, pNodeData );
		pMethods = (*itClasses)->GetMethods();
		for( itMethods=pMethods->begin(); itMethods!=pMethods->end(); ++itMethods ){
			ChildNode = m_pClassTree->InsertItem( Node, m_pClassTree->GetChildrenCount(Node,false), wxString((wxChar*)(*itMethods)->GetName().c_str()) );
			pNodeData = new CTreeNode( *itMethods );
			m_pClassTree->SetItemData( ChildNode, pNodeData );
		}
		pVariables = (*itClasses)->GetVariables();
		for( itVariables=pVariables->begin(); itVariables!=pVariables->end(); ++itVariables ){
			ChildNode = m_pClassTree->InsertItem( Node, m_pClassTree->GetChildrenCount(Node,false), wxString((wxChar*)(*itVariables)->GetName().c_str()) );
			pNodeData = new CTreeNode( *itVariables );
			m_pClassTree->SetItemData( ChildNode, pNodeData );
		}
	}
	m_pClassTree->SortChildren( Root );
	m_pClassTree->Expand( Root );
}

void CMainFrame::OnItemActivated( wxTreeEvent &Event )

{
	if( m_pClassTree->GetRootItem() == Event.GetItem() )
		return;

	CTreeNode		*pNode;
	wxCommandEvent	RebuildEvent(EVT_REBUILD_TREE);

	pNode = (CTreeNode*)m_pClassTree->GetItemData(Event.GetItem());
	if( pNode->GetType() == TClass ){
		CClass		TheCopy( *(pNode->GetClass()) );
		CClassDlg	ClassDlg( this, m_pCurrentDoc, &TheCopy );

		ClassDlg.Setup();
		if( ClassDlg.ShowModal() == wxID_OK )
			TheCopy.CopyTo( *(pNode->GetClass()) );
		m_pCurrentDoc->Modify( true );
		Event.Veto();
		wxPostEvent( this, RebuildEvent );
	} else if( pNode->GetType() == TMethod ){
		CMethod		TheCopy( *(pNode->GetMethod()) );
		CMethodDlg	MethodDlg( this, &TheCopy, m_pCurrentDoc );
		
		MethodDlg.Setup();
		if( MethodDlg.ShowModal() == wxID_OK )
			TheCopy.CopyTo( *(pNode->GetMethod()) ); 
		m_pCurrentDoc->Modify( true );
		Event.Veto();
		wxPostEvent( this, RebuildEvent );
	} else if( pNode->GetType() == TVariable ){
		CVariable		TheCopy( *(pNode->GetVariable()) );
		CVariableDlg	VariableDlg( this, &TheCopy, false, m_pCurrentDoc );

		VariableDlg.Setup();
		if( VariableDlg.ShowModal() == wxID_OK )
			TheCopy.CopyTo( *(pNode->GetVariable()) );
		m_pCurrentDoc->Modify( true );
		Event.Veto();
		wxPostEvent( this, RebuildEvent );
	}
	// hack here, but I don't know what else to do.  The class
	// needs to rebuild its rectangle now since its size might
	// have changed.  So I just grab any old view (they're all
	// the same at this point) and use that to let the class
	// figure out its new size
	CKlassModelerView	*pView;
	pView = (CKlassModelerView*)m_pCurrentDoc->GetFirstView();
	if( pView == NULL )
		return;
	pView->GetCanvas()->ComputeSizes();
	m_pCurrentDoc->UpdateAllViews();
}

// if you try to rebuild the tree from within a tree event
// you will get a crash (at least in Windows).  So I made
// a custom even to rebuild the tree.  That way all the other
// events will finish and the tree will be stable before I go
// mucking with it.
void CMainFrame::OnRebuildTree( wxCommandEvent &Event )
{
	DrawTree( m_pCurrentDoc, true );
}

// The tree node type
//
CTreeNode::CTreeNode( CClass *pClass )
{
	m_pClass = pClass;
	m_Type = TClass;
}

CTreeNode::CTreeNode( CMethod *pMethod )
{
	m_pMethod = pMethod;
	m_Type = TMethod;
}

CTreeNode::CTreeNode( CVariable *pVariable )
{
	m_pVariable = pVariable;
	m_Type = TVariable;
}

CTreeNode::~CTreeNode()
{
	m_pClass = NULL;
}


