/***************************************************************************
                             CodeObjectsDlg.h
                             -------------------
    begin                : Fri April 11, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#ifndef _CODEOBJECTSDLG_H_
#define _CODEOBJECTSDLG_H_

#include <wx/dialog.h>
#include <wx/textctrl.h>

class CClass;
class CMethod;
class CVariable;
class CObjectNotebook;
class CKlassModelerDoc;

class CCodeObjectsDlg : public wxDialog
{
public:
	CCodeObjectsDlg( wxWindow *pParent, wxString Title, CKlassModelerDoc *pDoc );
	virtual				~CCodeObjectsDlg();
	void				Setup();
	virtual void		OnSetup()=0;
	void				OKPressed( wxCommandEvent &Event );
	virtual void		OnOK()=0;
	virtual void		OnMethodActivated( CMethod *pMethod ){}
	virtual void		OnVariableActivated( CVariable *pVariable ){}
	DECLARE_EVENT_TABLE()
protected:
	CObjectNotebook		*m_pNotebook;
	CKlassModelerDoc	*m_pDoc;
};

class CClassDlg : public CCodeObjectsDlg
{
public:
	CClassDlg( wxWindow *pParent, CKlassModelerDoc *pDoc, CClass *pClass );
	virtual				~CClassDlg();
	virtual void		OnSetup();
	virtual void		OnOK();
	virtual void		OnMethodActivated( CMethod *pMethod );
	virtual void		OnVariableActivated( CVariable *pVariable );
protected:
	CClass				*m_pClass;
	wxTextCtrl			*m_pClassName;
};

class CMethodDlg : public CCodeObjectsDlg
{
public:
	CMethodDlg( wxWindow *pParent, CMethod *pMethod, CKlassModelerDoc *pDoc );
	virtual				~CMethodDlg();
	virtual void		OnSetup();
	virtual void		OnOK();
	virtual void		OnVariableActivated( CVariable *pVariable );
protected:
	CMethod				*m_pMethod;
	wxTextCtrl			*m_pMethodName;
	wxComboBox			*m_pReturnType;
	wxRadioBox			*m_pAccessType;
	wxCheckBox			*m_pPureVirtual;
	wxCheckBox			*m_pQtSignal;
	wxCheckBox			*m_pQtSlot;
	wxCheckBox			*m_pConst;
};

class CVariableDlg : public CCodeObjectsDlg
{
public:
	CVariableDlg( wxWindow *pParent, CVariable *pVariable, bool bIsArg, CKlassModelerDoc *pDoc );
	~CVariableDlg();
	virtual void		OnSetup();
	virtual void		OnOK();
protected:
	CVariable			*m_pVariable;
	bool				m_bIsArg;
	wxTextCtrl			*m_pName;
	wxComboBox			*m_pType;
	wxRadioBox			*m_pAccessType;
};

#endif
