/***************************************************************************
                          CodeObjects.cpp  -  description
                             -------------------
    begin                : Wed Dec 5 2001
    copyright            : (C) 2001 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify  
   it under the terms of the GNU General Public License as published by  
   the Free Software Foundation; either version 2 of the License, or     
   (at your option) any later version.
 ***************************************************************************/
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "CodeObjects.h"
#include "KlassModelerDoc.h"

//
// CClass
//
CClass::CClass( CKlassModelerDoc &Doc )
	: m_KMDoc( Doc )
{
	m_Name = "NewClass";
	m_bIsQObject = false;
	m_bExcludeHeader = false;
	m_bExcludeHTML = false;
}

CClass::CClass( CClass &Copy )
	: m_KMDoc( Copy.m_KMDoc )
{
	Copy.CopyTo( *this );
}

CClass::~CClass()
{
	Delete();
}

void CClass::Delete()
{
	VariableVector::iterator	itVariable;
	MethodVector::iterator		itMethod;
	InheritenceVector::iterator	itInheritence;
	RelationVector::iterator	itRelation;
	EnumVector::iterator		itEnum;
	
	for( itMethod=m_Methods.begin(); itMethod!=m_Methods.end(); ++itMethod ){
		delete *itMethod;
	}
	m_Methods.clear();
	for( itVariable=m_Variables.begin(); itVariable!=m_Variables.end(); ++itVariable ){
		delete *itVariable;
	}	
	m_Variables.clear();
	for( itInheritence=m_Inheritence.begin(); itInheritence!=m_Inheritence.end(); ++itInheritence ){
		delete *itInheritence;
	}
	m_Inheritence.clear();
	for( itRelation=m_Relation.begin(); itRelation!=m_Relation.end(); ++itRelation ){
		delete *itRelation;
	}
	m_Relation.clear();
	for( itEnum=m_Enums.begin(); itEnum!=m_Enums.end(); ++itEnum )
		delete *itEnum;
	m_Enums.clear();
}

void CClass::CopyTo( CClass &Dest )
{
	VariableVector::iterator	itVariable;
	MethodVector::iterator		itMethod;
	InheritenceVector::iterator	itInheritence;
	RelationVector::iterator	itRelation;
	EnumVector::iterator		itEnum;
	CMethod						*pNewMethod;
	CVariable					*pNewVariable;
	CInheritence				*pNewInheritence;
	CRelation					*pNewRelation;
	CEnum						*pNewEnum;
		
	Dest.Delete();
	Dest.m_Name = m_Name;
	Dest.m_Doc = m_Doc;
	Dest.m_HeaderFile = m_HeaderFile;
	Dest.m_HTMLFile = m_HTMLFile;
	Dest.m_X = m_X;
	Dest.m_Y = m_Y;
	Dest.m_bIsQObject = m_bIsQObject;
	Dest.m_bExcludeHeader = m_bExcludeHeader;
	Dest.m_bExcludeHTML = m_bExcludeHTML;
	Dest.m_Rect = m_Rect;	
	for( itMethod=m_Methods.begin(); itMethod!=m_Methods.end(); ++itMethod ){
		pNewMethod = new CMethod( **itMethod );
		Dest.m_Methods.push_back( pNewMethod );
	}
	for( itVariable=m_Variables.begin(); itVariable!=m_Variables.end(); ++itVariable ){
		pNewVariable = new CVariable( **itVariable );
		Dest.m_Variables.push_back( pNewVariable );
	}	
	for( itInheritence=m_Inheritence.begin(); itInheritence!=m_Inheritence.end(); ++itInheritence ){
		pNewInheritence = new CInheritence( **itInheritence );
		Dest.m_Inheritence.push_back( pNewInheritence );
	}
	for( itRelation=m_Relation.begin(); itRelation!=m_Relation.end(); ++itRelation ){
		pNewRelation = new CRelation( **itRelation );
		Dest.m_Relation.push_back( pNewRelation );
	}
	for( itEnum=m_Enums.begin(); itEnum!=m_Enums.end(); ++itEnum ){
		pNewEnum = new CEnum( **itEnum );
		Dest.m_Enums.push_back( pNewEnum );
	}
}

void CClass::SetName( string Name )
{
	m_Name = Name;
	m_KMDoc.AddNewType( Name );
}

void CClass::SetPosition( const wxPoint &Position )
{
	m_X = Position.x;
	m_Y = Position.y;
}

wxPoint CClass::GetPosition()
{
	wxPoint	RetVal;
	RetVal.x = (int)m_X;
	RetVal.y = (int)m_Y;
	
	return RetVal;
}

// it's not really a good design idea to have the rect computation
// going on inside the class.  Ideally the View would be responsible
// for figuring out the size.  But the amount of time it takes
// to compute the rect is painfully long for a redraw.  So just compute
// it when I know it changes.
void CClass::ComputeRect( wxDC *pDC )
{
	MethodVector					*pMethods;
	MethodVector::iterator		itMethods;
	VariableVector					*pVariables;
	VariableVector::iterator	itVariables;
	int								Width;
	int								MaxWidth=0;
	int								MethodHeight=0;
	int								VariableHeight=0;
	int								TotalHeight;
	int								TextHeight;

	pDC->GetTextExtent( wxString((wxChar*)GetName().c_str()), &MaxWidth, &TextHeight );
	MaxWidth += 10;
	// first figure out how many methods there are
	pMethods = GetMethods();
	for( itMethods=pMethods->begin(); itMethods!=pMethods->end(); ++itMethods ){
		MethodHeight++;
		pDC->GetTextExtent( wxString((wxChar*)(*itMethods)->GetFullText().c_str()), &Width, &TextHeight );
		Width += TextHeight+10;
		if( Width > MaxWidth )
			MaxWidth = Width;
	}
	// now do the variables
	pVariables = GetVariables();
	for( itVariables=pVariables->begin(); itVariables!=pVariables->end(); ++itVariables ){
		VariableHeight++;
		pDC->GetTextExtent( wxString((wxChar*)(*itVariables)->GetFullText().c_str()), &Width, &TextHeight );
		Width += TextHeight+10;
		if( Width > MaxWidth )
			MaxWidth = Width;
	}
	TotalHeight = VariableHeight+MethodHeight+1;
	m_Rect.x = GetPosition().x;
	m_Rect.y = GetPosition().y;
	m_Rect.width = MaxWidth;
	m_Rect.height = TotalHeight*TextHeight+5;
}

void CClass::GetRect( wxRect &BoundingRect )
{
	BoundingRect = m_Rect;
}

CMethod *CClass::GetMethod( int Index )
{
	if( Index < 0 )
		return NULL;
	if( Index >= m_Methods.size() )
		return NULL;
		
	return m_Methods[Index];	
}

void CClass::DeleteMethod( int Index )
{
	delete m_Methods[Index];
	for( int i=Index; i<m_Methods.size(); i++ ){
		if( i+1 < m_Methods.size() )
			m_Methods[i] = m_Methods[i+1];
	}
	m_Methods.resize( m_Methods.size()-1 );
}

CVariable *CClass::GetVariable( int Index )
{
	if( Index < 0 )
		return NULL;
	if( Index >= m_Variables.size() )
		return NULL;
		
	return m_Variables[Index];	
}

void CClass::SwapMethods( int Index1, int Index2 )
{
	if( Index1<0 || Index2<0 )
		return;
	if( Index1>=m_Methods.size() || Index2>=m_Methods.size() )
		return;
	CMethod	*pMethod;
	pMethod = m_Methods[Index1];
	m_Methods[Index1] = m_Methods[Index2];
	m_Methods[Index2] = pMethod;
}

void CClass::DeleteVariable( int Index )
{
	delete m_Variables[Index];
	for( int i=Index; i<m_Variables.size(); i++ ){
		if( i+1 < m_Variables.size() )
			m_Variables[i] = m_Variables[i+1];
	}
	m_Variables.resize( m_Variables.size()-1 );
}

void CClass::SwapVariables( int Index1, int Index2 )
{
	if( Index1<0 || Index2<0 )
		return;
	if( Index1>=m_Variables.size() || Index2>=m_Variables.size() )
		return;
	CVariable	*pVariable;
	pVariable = m_Variables[Index1];
	m_Variables[Index1] = m_Variables[Index2];
	m_Variables[Index2] = pVariable;
}

void CClass::DeleteEnum( int Index )
{
   delete m_Enums[Index];
   for( int i=Index; i<m_Enums.size(); i++ ){
		if( i+1 < m_Enums.size() )
			m_Enums[i] = m_Enums[i+1];
	}
	m_Enums.resize( m_Enums.size()-1 );
}

CEnum *CClass::GetEnum( int Index )
{
	if( Index < 0 )
		return NULL;
	if( Index >= m_Enums.size() )
		return NULL;
		
	return m_Enums[Index];	
}

CInheritence *CClass::GetInheritence( int Index )
{
	if( Index < 0 )
		return NULL;
	if( Index >= m_Inheritence.size() )
		return NULL;

	return m_Inheritence[Index];
}

void CClass::DeleteInheritence( int Index )
{
   delete m_Inheritence[Index];
   for( int i=Index; i<m_Inheritence.size(); i++ ){
		if( i+1 < m_Inheritence.size() )
			m_Inheritence[i] = m_Inheritence[i+1];
	}
	m_Inheritence.resize( m_Inheritence.size()-1 );
}

void CClass::DeleteRelation( int Index )
{
   delete m_Relation[Index];
   for( int i=Index; i<m_Relation.size(); i++ ){
		if( i+1 < m_Relation.size() )
			m_Relation[i] = m_Relation[i+1];
	}
	m_Relation.resize( m_Relation.size()-1 );
}

//
// CMethod
//
CMethod::CMethod( CKlassModelerDoc &Doc ) 
	: m_KMDoc( Doc )
{
	m_Name = "NewMethod";
	m_ReturnType = "void";
	m_Access = Public;
	m_bPureVirtual = false;
	m_bIsQtSignal = false;
	m_bIsQtSlot = false;
	m_bIsConst = false;
}

CMethod::CMethod( CMethod &Copy )
	: m_KMDoc( Copy.m_KMDoc )
{
	Copy.CopyTo( *this );
}

CMethod::~CMethod()
{
	Delete();
}

void CMethod::Delete()
{
	VariableVector::iterator	itVect;
	
	for( itVect=m_Args.begin(); itVect!=m_Args.end(); ++itVect ){
		delete *itVect;
	}	
	m_Args.clear();
}

void CMethod::CopyTo( CMethod &Dest )
{
	VariableVector::iterator	itVect;
	CVariable					*pVarCopy;

	Dest.Delete();
	Dest.m_Name = m_Name;
	Dest.m_ReturnType = m_ReturnType;
	Dest.m_Doc = m_Doc;
	Dest.m_InlineCode = m_InlineCode;
	Dest.m_Access = m_Access;
	Dest.m_bPureVirtual = m_bPureVirtual;
	Dest.m_bIsConst = m_bIsConst;
	Dest.m_bIsQtSignal = m_bIsQtSignal;
	Dest.m_bIsQtSlot = m_bIsQtSlot;
	for( itVect = m_Args.begin(); itVect!=m_Args.end(); ++itVect ){
		pVarCopy = new CVariable( **itVect );
		Dest.m_Args.push_back( pVarCopy );
	}
}

void CMethod::SetReturnType( string RetType )
{
	m_ReturnType = RetType; 
	m_KMDoc.AddNewType( RetType );
}

string CMethod::GetFullText()
{
	string 						FullText;
	VariableVector::iterator	itVect;
	bool						ExtraSpace = false;

	FullText = m_ReturnType;
	FullText += " ";
	FullText += m_Name;
	FullText += "(";
	for( itVect=m_Args.begin(); itVect!=m_Args.end(); ++itVect ){
		ExtraSpace = true;
		if( itVect != m_Args.begin() )
			FullText += ",";
		FullText += " ";
		FullText += (*itVect)->GetFullText();
	}
	if( ExtraSpace )
		FullText += " )";
	else
		FullText += ")";
	if( m_bIsConst )
		FullText += " const";
	if( m_bPureVirtual )
		FullText += "=0";
	
	return FullText;
}

CVariable *CMethod::GetArg( int Index )
{
	if( Index < 0 )
		return NULL;
	if( Index >= m_Args.size() )
		return NULL;
		
	return m_Args[Index];	
}

void CMethod::DeleteArg( int Index )
{
	delete m_Args[Index];
	for( int i=Index; i<m_Args.size(); i++ ){
		if( i+1 < m_Args.size() )
			m_Args[i] = m_Args[i+1];
	}
	m_Args.resize( m_Args.size()-1 );
}

void CMethod::SwapArgs( int Index1, int Index2 )
{	
	if( Index1<0 || Index2<0 )
		return;
	if( Index1>=m_Args.size() || Index2>=m_Args.size() )
		return;
	CVariable	*pArg;
	pArg = m_Args[Index1];
	m_Args[Index1] = m_Args[Index2];
	m_Args[Index2] = pArg;
}

// try to keep people from ending in }; which screws up
// code generation
void CMethod::SetInlineCode( string Code )
{ 
	int		pos;

	m_InlineCode = Code; 
	pos = m_InlineCode.rfind( "};" );
	while( pos != m_InlineCode.npos ){
		m_InlineCode.replace( pos, 2, "} ;" );
		pos = m_InlineCode.rfind( "};" );
	}
}

//
// CVariable
//
CVariable::CVariable( CKlassModelerDoc &Doc )
	: m_KMDoc( Doc )
{
	m_Name = "NewVariable";
	m_Type = "int";
	m_Access = Private;
}

CVariable::CVariable( CVariable &Copy )
	: m_KMDoc( Copy.m_KMDoc )
{
	Copy.CopyTo( *this );
}

CVariable::~CVariable()
{
}

void CVariable::CopyTo( CVariable &Dest )
{
	Dest.m_Access = m_Access;
	Dest.m_Name = m_Name;
	Dest.m_Type = m_Type;
	Dest.m_Doc = m_Doc;
}

void CVariable::SetType( string Type )
{ 
	m_Type = Type; 
	m_KMDoc.AddNewType( Type );
}

string CVariable::GetFullText()
{
	string	RetString;
	
	RetString = m_Type;
	RetString += " ";
	RetString += m_Name;
	
	return RetString;
}

//
// CEnum
//
CEnum::CEnum( CKlassModelerDoc &Doc )
	: m_KMDoc( Doc )
{ 
	m_FullText="{} ;"; 
	m_Access = Public; 
}

CEnum::CEnum( CEnum &Copy )
	: m_KMDoc( Copy.m_KMDoc )
{
	m_Name = Copy.m_Name;
	m_Access = Copy.m_Access;
	m_FullText = Copy.m_FullText;
}

void CEnum::SetName( string Name )
{ 
	m_Name = Name; 
	m_KMDoc.AddNewType( Name );
}

// the problem is in code generation.  I find the end of a class
// by searching for the '};'.  Enums also end with that which
// screws everything up.  So force enums to end in '} ;'
// it's ugly, but it makes it work.
void CEnum::SetText( string t )
{ 
	int		pos;

	m_FullText = t; 
	pos = m_FullText.rfind( "};" );
	if( pos == m_FullText.npos )
		return;
	m_FullText.replace( pos, 2, "} ;" );
}


//
// CInheritence
//
CInheritence::CInheritence()
{
   m_pParent = NULL;
   m_Horizontal = 50;
   m_bVisible = false;
}

CInheritence::CInheritence( CInheritence &Copy )
{
	m_pParent = Copy.m_pParent;
	m_Horizontal = Copy.m_Horizontal;
	m_bVisible = Copy.m_bVisible;
	m_ParentName = Copy.m_ParentName;
}

CInheritence::~CInheritence()
{
}

void CInheritence::SetParent( CClass *pParent )
{
   if( pParent == NULL ) return;
   m_pParent = pParent;
   m_ParentName = pParent->GetName();
   m_bVisible = true;
}

string CInheritence::GetParentName()
{
	if( m_pParent )
		m_ParentName = m_pParent->GetName();

	return m_ParentName;
}

//
// CRelation
//
CRelation::CRelation( CRelation &Copy )
{
	m_pChild = Copy.m_pChild;
	m_ParentName = Copy.m_ParentName;
	m_bIsHasA = Copy.m_bIsHasA;
}


