package jzipdotorg;

import javax.swing.UIManager;
import java.awt.*;
import java.util.*;
 
 /**
 * Title: jzip.org
 * version 0.1.1
 * Description: main() for jzip.org project
 * Copyright: Copyright (c) 2003 Grzegorz Kowal

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
 * author:Grzegorz Kowal - wolk!
 * contact: greg_kowal@hotmail.com
 */

public class starter 
{  
  	boolean packFrame = false;

  	//Construct the application
  	public starter() 
  	{
	    GUI frame = new GUI();
	    
	    if (packFrame) 
	    {
	    	frame.pack();
	    }
    	else 
    	{
      		frame.validate();
    	}
    	
    	//Center the window
	    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	    
	    Dimension frameSize = frame.getSize();
	    
	    if (frameSize.height > screenSize.height) 
	    {
	      	frameSize.height = screenSize.height;
	    }
	    if (frameSize.width > screenSize.width) 
	    {
	      	frameSize.width = screenSize.width;
	    }
	    
	    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
	    
	    frame.setVisible(true);
	  }
  
  public starter(String[] s) 
  {
  	  
    GUI frame = new GUI(s);
    
    if (packFrame) 
    {
    	frame.pack();
    }
    else 
    {
      	frame.validate();
    }
    //Center the window
    
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    
    Dimension frameSize = frame.getSize();
    
    if (frameSize.height > screenSize.height) 
    {
      	frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) 
    {
      	frameSize.width = screenSize.width;
    }
    
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    
    frame.setVisible(true);
  }
  //Main method
  public static void main(String[] args) {

    try 
    {
    	
		//To get "your look" enable one of the lines beneth.
	    
	   	UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
	    
	    //UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
	    //UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
	    //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    
    }
    catch(Exception e) 
    {
      	e.printStackTrace();
    }
    
    if(args.length >= 1)
    {
    	//System.out.println(args[0]);
    	
    	new starter(args);
    }
    
    else if(args.length == 0)
    {
    	new starter();
    }
  }
}