package jzipdotorg;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.net.*;
import javax.swing.table.*;
import javax.swing.table.AbstractTableModel.*;
import java.text.*;

/**
 * Title: jzip.org
 * version 0.1.1
 * Description: methods for GUI for jzip.org project
 * Copyright: Copyright (c) 2003 Grzegorz Kowal

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
 * author:Grzegorz Kowal - wolk!
 * contact: greg_kowal@hotmail.com
 */

class MyFilter extends javax.swing.filechooser.FileFilter
{
    public boolean accept(File file)
    {
        String fileA = file.getName();
        if (file.isDirectory() || fileA.endsWith(".zip"))
          return true;
        else
          return false;
    }
    public String getDescription()
    {
        return "*.zip";
    }
}

public class WorkHorse
{

	static final int BUFFER = 2048;
	static final int COLS 	= 4;
	static final int ROWS 	= 0;	

	String filename;

	Vector ent = new Vector(1);
	
	Object[][] o= new Object[ROWS][COLS];
	
	String parentDir;
	
	public Object[][] getObject()
	{
		return o;
	}
	
	void deb(String s)
	{
		System.out.println(s);
	}

	boolean newFile(JFileChooser fileChooser)
	{
		o= new Object[ROWS][COLS];
		
	        File tmpfile = fileChooser.getSelectedFile();

	        filename = tmpfile.toString();

            try
            {
				FileOutputStream fis = new FileOutputStream(filename);					
            }

            catch(IOException e)
            {
                System.out.println("Problem with IO...sorry mate!");

                e.printStackTrace();
            }
			
			ent.clear();
			
            return true;

     }//end of newFile()
         
	 boolean openFile(File tmpfile)
     {

		filename = tmpfile.getPath();

        try
        {
			ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(filename)));

            ZipEntry entry;
            
            long size, compressed, time;
            
            DateFormat df;            

            while((entry = zis.getNextEntry()) != null)
            {            	
				ent.addElement(entry);
			}
			
			o = new Object[ent.size()][COLS];
			for(int i=0; i<ent.size(); i++)
			{
				ZipEntry z = (ZipEntry)ent.get(i);
				
				o[i][0] = z.getName();
				o[i][1] = new Long(z.getSize());
				o[i][2] = new Long(z.getCompressedSize());
				o[i][3] = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM).format(new Date(z.getTime()));
				
			}

        }

        catch(IOException e)
        {
			System.out.println("Problem with IO...sorry mate!");

			e.printStackTrace();
        }

                return true;
    }//end of openFile()


    boolean addFile(JFileChooser fileChooser)
    {
        File f[];

        f = new File[ fileChooser.getSelectedFiles().length ];

        f = fileChooser.getSelectedFiles();
        
        parentDir = f[0].getParent();


        try
        {

			ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename, true)));
	
	        zos.setLevel(9);

            for(int i=0; i<f.length; i++)
            {
				if(f[i].isFile())
				{ 
					zipItIn(f[i], new File(""), zos);
				}
                else if(f[i].isDirectory())
                {
                	deb("in addFile");
                
	                try
	                {
	                	zos.putNextEntry(new ZipEntry(f[i].getName() + "/"));
	    	   			zos.closeEntry();
	    	   		}
	    	   		catch(Exception e)
	    	   		{
	    	   			deb("upsss");
	    	   		}
    	   		
	    	   		ent.addElement(new ZipEntry(f[i].getName() + "/"));
	    	   			
	                recursivZip(f[i], new File(f[i].getName()), zos);
                }
            }

            zos.close();



        }

        catch(IOException e)
		{
			System.out.println("Problem with IO...sorry mate!");

                    e.printStackTrace();
		}
		
		o = new Object[ent.size()][COLS];
		
		for(int i=0; i<ent.size(); i++)
		{
			ZipEntry z = (ZipEntry)ent.get(i);
			
			o[i][0] = z.getName();
			o[i][1] = new Long(z.getSize());
			o[i][2] = new Long(z.getCompressedSize());
			o[i][3] = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM).format(new Date(z.getTime()));
			
		}

        return true;

    }//end of addFile()

    boolean extractFile(JFileChooser fileChooser, Object[] o)
    {
        byte data[] = new byte[BUFFER];

        File dirToExtractTo = fileChooser.getSelectedFile();
        
        try
       	{
        
	        ZipFile zipFile = new ZipFile(filename);
	                
            for (int i=0; i<o.length; i++)
        	{
	    		File zipped = new File(o[i].toString());
	    		
	    		File newExtractedFile = new File(dirToExtractTo, zipped.getPath());
	    		
	    		ZipEntry zipEntry = zipFile.getEntry(o[i].toString());
	    		
	    		if(zipEntry.isDirectory())
	    		{
        			newExtractedFile.mkdirs();
        			
        			deb("dir"+i);
        		}
	            		
        		else if(zipEntry.isDirectory() == false)
        		{
        			newExtractedFile.getParentFile().mkdirs();
        			
            		BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry), BUFFER);//wonder if BufferedInputStream would help?
            		
            		BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newExtractedFile), BUFFER);
							    
                    int count;

                    while ((count = bis.read(data, 0 , BUFFER))!= -1)
                    {
		        		bos.write(data, 0, count);
                    }

                    bos.close();
              	}
              }
            }
                      
          	catch(IOException e)
          	{
				System.out.println("Problem with IO...sorry mate!");
	
				e.printStackTrace();
	        }

            return true;
	    }//end of extractFile()

    //--------------------------Private functions------------------------------

        private void zipItIn(File f, File currentDir, ZipOutputStream zos)
        {
	        String relevantPath = "";

	        try
	        {
				BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f), BUFFER);
	
	
				if(currentDir.getPath().length() == 0)
					relevantPath = f.getName();
				else
				{
			
					/*whole fun with URL is because of "\" and "/". Windows uses "\"
					  and Unix "/" Because we want zip files to be working on both 
					  platforms we need"/". As we can't get it other way I have used 
					  URL because it is always using "/".*/
					try 
					{
						
						relevantPath = new URL("file:" + currentDir.getPath() + f.separator + f.getName()).getPath();
					
					}
					catch(MalformedURLException m)
					{
						
						deb("problems creating URL");
					
					}
					
				 }
				 
				 ZipEntry entry = new ZipEntry(relevantPath);
				 
				 File orginal =new File(parentDir, relevantPath);
	
		         entry.setSize(orginal.length());
		         
		         zos.putNextEntry(entry);
	
	             int count;

				byte data[] = new byte[BUFFER];

                while ((count = bis.read(data, 0 , BUFFER))!= -1)
                {
					zos.write(data, 0, count);
				}

                ent.addElement(entry);

                bis.close();

            }

            catch(IOException e)
            {
				System.out.println("Problem with IO...sorry mate!");

                e.printStackTrace();
            }

        }//end of zipItIn()

        private void recursivZip(File f, File currentDir, ZipOutputStream zos)
        {
    		String relevantPath = "";    		
    		
            for (int i=0; i<f.list().length; i++)
            {
            	File fileToBeZipped = f.listFiles()[i];
            	
				if(fileToBeZipped.isFile())
					zipItIn(fileToBeZipped, currentDir, zos);

                else if(fileToBeZipped.isDirectory())
                {

                	try
                	{
                		
                		/*Whole fun with URL is because of "\" and "/". Windows uses "\"
						  and Unix "/" Because we want zip files to be working on both 
						  platforms we need"/". As we can't get it other way I have used 
						  URL because it is always using "/".*/
						  
                		try
                		{
                			relevantPath = new URL("file:" + currentDir.getPath() + f.separator + fileToBeZipped.getName() + "/").getPath();
                		}
						catch(MalformedURLException m)
						{
							deb("problems creating URL");
						}
                		
                		zos.putNextEntry(new ZipEntry(relevantPath));
                	   	zos.closeEntry();
                	}
                	catch(Exception e)
                	{
                		deb("upsss");
                	}
                	ent.addElement(new ZipEntry(relevantPath));                	
                	
                    recursivZip(fileToBeZipped, new File(currentDir.getPath() + f.separator + fileToBeZipped.getName()), zos);
                
                }
            }

    }//end of recursivZip()


}//end of WorkHorse
