package jzipdotorg;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * Title: jzip.org
 * version 0.1.1
 * Description: GUI for jzip.org project
 * Copyright: Copyright (c) 2003 Grzegorz Kowal

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
 * author:Grzegorz Kowal - wolk!
 * contact: greg_kowal@hotmail.com
 */

public class GUI_AboutBox extends JDialog implements ActionListener {

  
  JPanel 		panel1 			= new JPanel();
  JPanel 		panel2 			= new JPanel();
  JPanel 		insetsPanel1 	= new JPanel();
  JPanel 		insetsPanel2 	= new JPanel();
  JPanel 		insetsPanel3 	= new JPanel();
  JButton 		button1 		= new JButton();
  JLabel 		imageLabel 		= new JLabel();
  JLabel 		label1 			= new JLabel();
  JLabel 		label2 			= new JLabel();
  JLabel 		label3 			= new JLabel();
  JLabel 		label4 			= new JLabel();
  JLabel 		label5 			= new JLabel();
  BorderLayout 	borderLayout1 	= new BorderLayout();
  BorderLayout 	borderLayout2 	= new BorderLayout();
  FlowLayout 	flowLayout1 	= new FlowLayout();
  GridLayout 	gridLayout1 	= new GridLayout();
  String 		product 		= "jzip.org 0.1.2";  
  String 		copyright 		= "Copyright (c) 2003 Grzegorz Kowal - wolk!";
  String 		email 			= "greg_kowal@hotmail.com";
  String 		comments 		= "http://jzipdotorg.cjb.net";
  String		project			= "http://sourceforge.net/projects/jzipdotorg";
  
  public GUI_AboutBox(Frame parent) {
    super(parent);
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    pack();
  }
  //Component initialization
  private void jbInit() throws Exception  {
    imageLabel.setIcon(new ImageIcon(GUI_AboutBox.class.getResource("/images/newJzip.org.png")));
    //this.setTitle("About");
    setResizable(false);
    panel1.setLayout(borderLayout1);
    panel2.setLayout(borderLayout2);
    insetsPanel1.setLayout(flowLayout1);
    insetsPanel2.setLayout(flowLayout1);
    insetsPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    gridLayout1.setRows(5);
    gridLayout1.setColumns(1);
    label1.setText(product);
    label2.setText(copyright);
    label3.setText(email);
    label4.setText(comments);
    label5.setText(project);
    
    insetsPanel3.setLayout(gridLayout1);
    insetsPanel3.setBorder(BorderFactory.createEmptyBorder(10, 60, 10, 10));
    button1.setText("Ok");
    button1.addActionListener(this);
    insetsPanel2.add(imageLabel, null);
    panel2.add(insetsPanel2, BorderLayout.WEST);

    
    this.getContentPane().add(panel1, null);
    insetsPanel3.add(label1, null);
    insetsPanel3.add(label2, null);
    insetsPanel3.add(label3, null);
    insetsPanel3.add(label4, null);
    insetsPanel3.add(label5, null);
    panel2.add(insetsPanel3, BorderLayout.CENTER);
    insetsPanel1.add(button1, null);
    panel1.add(insetsPanel1, BorderLayout.SOUTH);
    panel1.add(panel2, BorderLayout.NORTH);
  }
  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      cancel();
    }
    super.processWindowEvent(e);
  }
  //Close the dialog
  void cancel() {
    dispose();
  }
  //Close the dialog on a button event
  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == button1) {
      cancel();
    }
  }
}