/* ======================================================================== */
/*  JZPRINT -- Wrapper around printf() to vector stdout as appropriate.     */
/* ======================================================================== */


#include "config.h"
#include <stdio.h>
#include <stdarg.h>

int    jzp_silent = 0;
FILE  *jzp_stdout = NULL;
void (*jzp_vprintf)(void *arg, char *fmt, va_list ap) = NULL;
void  *jzp_vprintf_arg = NULL;

void jzp_printf(char *fmt, ...)
{
    va_list ap;

    if (jzp_silent)
        return;
    

    if (jzp_stdout)
    {
        va_start(ap, fmt);
        vfprintf(jzp_stdout, fmt, ap);
        va_end(ap);
    }

    if (jzp_vprintf)
    {
        va_start(ap, fmt);
        jzp_vprintf(jzp_vprintf_arg, fmt, ap);
        va_end(ap);
    }
}

void jzp_flush(void)
{
    if (!jzp_silent && jzp_stdout)
        fflush(jzp_stdout);
}

void jzp_init
(
    int silent, 
    FILE *fout, 
    void (*fn)(void *, char *, va_list),
    void *fn_arg
)
{
    jzp_silent  = silent;
    jzp_stdout  = fout;
    jzp_vprintf = fn;
    jzp_vprintf_arg = fn_arg;
}
