/*

Token parser class

Copyright (C) 2003  Joe Fisher, Shiny Technologies, LLC
http://www.shinytechnologies.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef TOKEN_H_INCLUDED
#define TOKEN_H_INCLUDED

#include <string>
#include "llist.h"

using namespace std;

class Token
{
public:
    Token(char *);
    ~Token();

    Token &operator =(Token &tok);
    Token &operator =(char *szBuff);
    Token &operator =(string &sBuff);

    const char *operator[](int i);

    int SetNewSeparators(char *);
    int Tokenize(char *);

    int GetNumTokens() {return m_tokList.GetNumNodes();}

private:
    void Tokenize();

    string m_str;
    string *m_pTok;
    char m_szTok[255];
    LList<string> m_tokList;
    char m_szSeps[255];
};

#endif

