/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.tokens;

import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class SimpleTokenizer
implements Tokenizer {
    public static final SimpleTokenizer DEFAULT_TOKENIZER = new SimpleTokenizer(true, true);
    private boolean ignorePunctuation = true;
    private boolean ignoreCase = true;
    private int nextId = 0;
    private Map tokMap = new TreeMap();

    public SimpleTokenizer(boolean bl, boolean bl2) {
        this.ignorePunctuation = bl;
        this.ignoreCase = bl2;
    }

    public void setIgnorePunctuation(boolean bl) {
        this.ignorePunctuation = bl;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public String toString() {
        return "[SimpleTokenizer " + this.ignorePunctuation + ";" + this.ignoreCase + "]";
    }

    public Token[] tokenize(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        int n = 0;
        while (n < string.length()) {
            StringBuffer stringBuffer;
            char c = string.charAt(n);
            if (Character.isWhitespace(c)) {
                ++n;
                continue;
            }
            if (Character.isLetter(c)) {
                stringBuffer = new StringBuffer("");
                while (n < string.length() && Character.isLetter(string.charAt(n))) {
                    stringBuffer.append(string.charAt(n));
                    ++n;
                }
                arrayList.add(this.internSomething(stringBuffer.toString()));
                continue;
            }
            if (Character.isDigit(c)) {
                stringBuffer = new StringBuffer("");
                while (n < string.length() && Character.isDigit(string.charAt(n))) {
                    stringBuffer.append(string.charAt(n));
                    ++n;
                }
                arrayList.add(this.internSomething(stringBuffer.toString()));
                continue;
            }
            if (!this.ignorePunctuation) {
                stringBuffer = new StringBuffer("");
                stringBuffer.append(c);
                String string2 = stringBuffer.toString();
                arrayList.add(this.internSomething(string2));
            }
            ++n;
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    private Token internSomething(String string) {
        return this.intern(this.ignoreCase ? string.toLowerCase() : string);
    }

    public Token intern(String string) {
        Token token = (Token)this.tokMap.get(string);
        if (token == null) {
            token = new Token(++this.nextId, string);
            this.tokMap.put(string, token);
        }
        return token;
    }

    public static void main(String[] stringArray) {
        SimpleTokenizer simpleTokenizer = DEFAULT_TOKENIZER;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.out.println("argument " + n2 + ": '" + stringArray[n2] + "'");
            Token[] tokenArray = simpleTokenizer.tokenize(stringArray[n2]);
            int n3 = 0;
            while (n3 < tokenArray.length) {
                System.out.println("token " + ++n + ":" + " id=" + tokenArray[n3].getIndex() + " value: '" + tokenArray[n3].getValue() + "'");
                ++n3;
            }
            ++n2;
        }
    }
}

