/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.tokens;

import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.ArrayList;

public class NGramTokenizer
implements Tokenizer {
    private int minNGramSize;
    private int maxNGramSize;
    private boolean keepOldTokens;
    private Tokenizer innerTokenizer;
    public static NGramTokenizer DEFAULT_TOKENIZER = new NGramTokenizer(3, 5, true, SimpleTokenizer.DEFAULT_TOKENIZER);

    public NGramTokenizer(int n, int n2, boolean bl, Tokenizer tokenizer) {
        this.minNGramSize = n;
        this.maxNGramSize = n2;
        this.keepOldTokens = bl;
        this.innerTokenizer = tokenizer;
    }

    public Token[] tokenize(String string) {
        Token[] tokenArray = this.innerTokenizer.tokenize(string);
        ArrayList<Token> arrayList = new ArrayList<Token>();
        int n = 0;
        while (n < tokenArray.length) {
            Token token = tokenArray[n];
            String string2 = "^" + token.getValue() + "$";
            if (this.keepOldTokens) {
                arrayList.add(this.intern(string2));
            }
            int n2 = 0;
            while (n2 < string2.length()) {
                int n3 = this.minNGramSize;
                while (n3 <= this.maxNGramSize) {
                    if (n2 + n3 < string2.length()) {
                        arrayList.add(this.innerTokenizer.intern(string2.substring(n2, n2 + n3)));
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    public Token intern(String string) {
        return this.innerTokenizer.intern(string);
    }

    public static void main(String[] stringArray) {
        NGramTokenizer nGramTokenizer = DEFAULT_TOKENIZER;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.out.println("argument " + n2 + ": '" + stringArray[n2] + "'");
            Token[] tokenArray = nGramTokenizer.tokenize(stringArray[n2]);
            int n3 = 0;
            while (n3 < tokenArray.length) {
                System.out.println("token " + ++n + ":" + " id=" + tokenArray[n3].getIndex() + " value: '" + tokenArray[n3].getValue() + "'");
                ++n3;
            }
            ++n2;
        }
    }
}

