/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;

public class WinklerRescorer
extends AbstractStringDistance {
    private StringDistance innerDistance;

    public WinklerRescorer(StringDistance stringDistance) {
        this.innerDistance = stringDistance;
    }

    public String toString() {
        return "[WinklerRescorer:" + this.innerDistance + "]";
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        double d = this.innerDistance.score(stringWrapper, stringWrapper2);
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("innerDistance should produce scores between 0 and 1");
        }
        int n = WinklerRescorer.commonPrefixLength(4, stringWrapper.unwrap(), stringWrapper2.unwrap());
        d += (double)n * 0.1 * (1.0 - d);
        return d;
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        double d = this.innerDistance.score(stringWrapper, stringWrapper2);
        int n = WinklerRescorer.commonPrefixLength(4, stringWrapper.unwrap(), stringWrapper2.unwrap());
        d += (double)n * 0.1 * (1.0 - d);
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("original score using " + this.innerDistance + ":\n");
        stringBuffer.append(this.innerDistance.explainScore(stringWrapper, stringWrapper2) + "\n");
        stringBuffer.append("prefLength = max(4,commonPrefixLength) = " + n + "\n");
        stringBuffer.append("Corrected score = dist + " + n + "/10 * (1-dist) = " + this.score(stringWrapper, stringWrapper2) + "\n");
        return stringBuffer.toString();
    }

    private static int commonPrefixLength(int n, String string, String string2) {
        int n2 = Math.min(n, Math.min(string.length(), string2.length()));
        int n3 = 0;
        while (n3 < n2) {
            if (string.charAt(n3) != string2.charAt(n3)) {
                return n3;
            }
            ++n3;
        }
        return n2;
    }

    public StringWrapper prepare(String string) {
        return this.innerDistance.prepare(string);
    }
}

