/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStatisticalTokenDistance;
import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.Iterator;

public class TokenFelligiSunter
extends AbstractStatisticalTokenDistance {
    private Tokenizer tokenizer;
    private double mismatchFactor = 0.5;

    public TokenFelligiSunter(Tokenizer tokenizer, double d) {
        this.tokenizer = tokenizer;
        this.mismatchFactor = d;
    }

    public TokenFelligiSunter() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER, 0.5);
    }

    public void setMismatchFactor(double d) {
        this.mismatchFactor = d;
    }

    public void setMismatchFactor(Double d) {
        this.mismatchFactor = d;
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (bagOfTokens2.contains(token)) {
                d += bagOfTokens2.getWeight(token);
                continue;
            }
            d -= bagOfTokens.getWeight(token) * this.mismatchFactor;
        }
        return d;
    }

    public StringWrapper prepare(String string) {
        BagOfTokens bagOfTokens = new BagOfTokens(string, this.tokenizer.tokenize(string));
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (this.collectionSize > 0) {
                Integer n = (Integer)this.documentFrequency.get(token);
                double d2 = n == null ? 1.0 : (double)n.intValue();
                double d3 = -Math.log(d2 / (double)this.collectionSize);
                bagOfTokens.setWeight(token, d3);
                continue;
            }
            bagOfTokens.setWeight(token, 1.0);
        }
        return bagOfTokens;
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        StringBuffer stringBuffer = new StringBuffer("");
        PrintfFormat printfFormat = new PrintfFormat("%.3f");
        stringBuffer.append("Common tokens: ");
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (!bagOfTokens2.contains(token)) continue;
            stringBuffer.append(" " + token.getValue() + ": ");
            stringBuffer.append(printfFormat.sprintf(bagOfTokens2.getWeight(token)));
        }
        stringBuffer.append("\nscore = " + this.score(stringWrapper, stringWrapper2));
        return stringBuffer.toString();
    }

    public String toString() {
        return "[TokenFelligiSunter]";
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new TokenFelligiSunter(), stringArray);
    }
}

