/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.MemoMatrix;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringWrapper;
import java.util.Random;

public class SLIM
extends AbstractStringDistance {
    private static final boolean TRACE = false;
    private static final int MAX_EM_ITERATIONS = 20;
    private static final double MIN_PARAMETER_CHANGE = 0.01;
    private static final double RANDOM_GAUSSIAN_SD = 1.0;
    private static double parameterPriorWeight = 0.0;
    private static double priorMean = 0.0;
    private static double priorVar = 1.0;
    private static double mixturePriorWeight = 0.0;
    private static double mixturePrior = 0.5;
    private static final boolean USE_TWO_GAUSSIANS = false;
    private static final boolean USE_TRIVIAL_MODEL = true;

    public String toString() {
        return "[SLIM]";
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        double d;
        double d2;
        String string;
        String string2 = stringWrapper.unwrap().toLowerCase();
        if (string2.equals(string = stringWrapper2.unwrap().toLowerCase())) {
            return 1.0;
        }
        Histogram histogram = new Histogram(string2, string);
        if (histogram.getTotalCount() <= 1) {
            d2 = (double)histogram.getTotalCount() / (double)string2.length();
            d = (double)histogram.getTotalCount() / (double)string.length();
        } else {
            MixtureModel mixtureModel = new MixtureModel(histogram);
            d2 = this.overlap(string2, string, mixtureModel);
            d = this.overlap(string, string2, mixtureModel);
        }
        double d3 = 0.5 * (d2 + d);
        return d3;
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        double d;
        double d2;
        String string;
        String string2 = stringWrapper.unwrap().toLowerCase();
        if (string2.equals(string = stringWrapper2.unwrap().toLowerCase())) {
            return "Strings are equal: score = 1.0";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("Co-occurence matrix:\n");
        stringBuffer.append(new MatchMemoMatrix(stringWrapper, stringWrapper2).toString());
        stringBuffer.append("\n\n");
        Histogram histogram = new Histogram(string2, string);
        if (histogram.getTotalCount() <= 1) {
            stringBuffer.append("No mixture model for " + histogram.getTotalCount() + " common letter(s)\n");
            d2 = (double)histogram.getTotalCount() / (double)string2.length();
            d = (double)histogram.getTotalCount() / (double)string.length();
        } else {
            MixtureModel mixtureModel = new MixtureModel(histogram);
            stringBuffer.append("Mixture model " + mixtureModel.toString() + "\n");
            PrintfFormat printfFormat = new PrintfFormat("%3d Pr(%3d): ");
            int n = histogram.getMinDiff();
            while (n <= histogram.getMaxDiff()) {
                double d3 = mixtureModel.posteriorProbOfGaussian(n);
                stringBuffer.append(printfFormat.sprintf(new Object[]{new Integer(n), new Integer((int)(100.0 * d3))}));
                int n2 = 0;
                while (n2 < histogram.getCount(n)) {
                    stringBuffer.append('*');
                    ++n2;
                }
                stringBuffer.append("\n");
                ++n;
            }
            stringBuffer.append("\nPosterior probability of Gaussian:\n");
            stringBuffer.append(new MixMemoMatrix(stringWrapper, stringWrapper2, mixtureModel).toString());
            stringBuffer.append("\n\n");
            d2 = this.overlap(string2, string, mixtureModel);
            d = this.overlap(string, string2, mixtureModel);
        }
        double d4 = 0.5 * (d2 + d);
        stringBuffer.append("sOverlap=" + d2 + " tOverlap=" + d + " score=" + d4 + "\n");
        stringBuffer.append("Score=" + this.score(stringWrapper, stringWrapper2) + "\n");
        return stringBuffer.toString();
    }

    private double overlap(String string, String string2, MixtureModel mixtureModel, int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = 1.0;
            int n3 = 0;
            while (n3 < string2.length()) {
                if (string.charAt(n2) == string2.charAt(n3)) {
                    d2 *= 1.0 - mixtureModel.posteriorProbOfGaussian(n2 - n3);
                }
                ++n3;
            }
            d2 = 1.0 - d2;
            d += d2;
            ++n2;
        }
        return d / (double)string.length();
    }

    private double overlap(String string, String string2, MixtureModel mixtureModel) {
        return this.overlap(string, string2, mixtureModel, string.length());
    }

    public StringWrapper prepare(String string) {
        return new StringWrapper(string);
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new SLIM(), stringArray);
    }

    static /* synthetic */ double access$000() {
        return priorMean;
    }

    static /* synthetic */ double access$100() {
        return priorVar;
    }

    static /* synthetic */ double access$200() {
        return mixturePrior;
    }

    static /* synthetic */ double access$300() {
        return parameterPriorWeight;
    }

    static /* synthetic */ double access$400() {
        return mixturePriorWeight;
    }

    private static class MixMemoMatrix
    extends MemoMatrix {
        private MixtureModel model;

        public MixMemoMatrix(StringWrapper stringWrapper, StringWrapper stringWrapper2, MixtureModel mixtureModel) {
            super(stringWrapper, stringWrapper2);
            this.model = mixtureModel;
        }

        double compute(int n, int n2) {
            if (this.sAt(n) != this.tAt(n2)) {
                return 0.0;
            }
            double d = this.model.posteriorProbOfGaussian(n - n2);
            if (d == 1.0) {
                return 99.0;
            }
            return (int)(d * 100.0);
        }
    }

    private static class MatchMemoMatrix
    extends MemoMatrix {
        public MatchMemoMatrix(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
            super(stringWrapper, stringWrapper2);
        }

        double compute(int n, int n2) {
            return this.sAt(n) == this.tAt(n2) ? 1.0 : 0.0;
        }
    }

    private static class MixtureModel {
        double[] z;
        double[] s;
        double probGaussian;
        double bigVariance;
        double bigMean;
        double mean;
        double var;
        double spread;

        public MixtureModel(Histogram histogram) {
        }

        private boolean changed(double d, double d2) {
            double d3 = d2 - d;
            if (d3 < 0.0) {
                d3 = -d3;
            }
            return d3 > 0.01;
        }

        private String toString(double[] dArray) {
            StringBuffer stringBuffer = new StringBuffer();
            PrintfFormat printfFormat = new PrintfFormat(" %.2g");
            int n = 0;
            while (n < dArray.length) {
                stringBuffer.append(printfFormat.sprintf(dArray[n]));
                ++n;
            }
            return stringBuffer.toString();
        }

        private double logPGaussian(double d, double d2, double d3) {
            double d4 = d - d2;
            return -2.0 * Math.log(6.2831854 * d3) - d4 * d4 / (2.0 * d3);
        }

        public double posteriorProbOfGaussian(double d) {
            return 1.0;
        }

        public String toString() {
            return "[mix:trivial]";
        }
    }

    private static class Histogram {
        int maxLength;
        int[] count;
        int totalCount;

        public Histogram(String string, String string2) {
            this.maxLength = Math.max(string.length(), string2.length());
            this.count = new int[2 * this.maxLength + 1];
            this.totalCount = 0;
            int n = 0;
            while (n < string.length()) {
                int n2 = 0;
                while (n2 < string2.length()) {
                    if (string.charAt(n) == string2.charAt(n2)) {
                        int n3 = n - n2;
                        int n4 = n3 + this.maxLength;
                        this.count[n4] = this.count[n4] + 1;
                        ++this.totalCount;
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public int getMinDiff() {
            return -this.maxLength;
        }

        public int getMaxDiff() {
            return this.maxLength;
        }

        public int getCount(int n) {
            return this.count[n + this.maxLength];
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            PrintfFormat printfFormat = new PrintfFormat("%3d: ");
            int n = this.getMinDiff();
            while (n <= this.getMaxDiff()) {
                stringBuffer.append(printfFormat.sprintf(n));
                int n2 = 0;
                while (n2 < this.getCount(n)) {
                    stringBuffer.append('*');
                    ++n2;
                }
                stringBuffer.append("\n");
                ++n;
            }
            return stringBuffer.toString();
        }

        public double[] toSample() {
            double[] dArray = new double[this.totalCount];
            Random random = new Random(0L);
            int n = 0;
            int n2 = this.getMinDiff();
            while (n2 <= this.getMaxDiff()) {
                int n3 = 0;
                while (n3 < this.getCount(n2)) {
                    dArray[n++] = (double)n2 + random.nextGaussian() * 1.0;
                    ++n3;
                }
                ++n2;
            }
            return dArray;
        }
    }
}

