/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.Levenstein;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.Iterator;

public class Level2
extends AbstractStringDistance {
    private Tokenizer tokenizer;
    private StringDistance tokenDistance;

    public Level2(Tokenizer tokenizer, StringDistance stringDistance) {
        this.tokenizer = tokenizer;
        this.tokenDistance = stringDistance;
    }

    public double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            double d2 = -1.7976931348623157E308;
            Iterator iterator2 = bagOfTokens2.tokenIterator();
            while (iterator2.hasNext()) {
                Token token2 = (Token)iterator2.next();
                double d3 = this.tokenDistance.score(token.getValue(), token2.getValue());
                d2 = Math.max(d2, d3);
            }
            d += d2;
        }
        return d / (double)bagOfTokens.size();
    }

    public StringWrapper prepare(String string) {
        return new BagOfTokens(string, this.tokenizer.tokenize(string));
    }

    public String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        StringBuffer stringBuffer = new StringBuffer();
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            stringBuffer.append("token=" + token);
            double d2 = -1.7976931348623157E308;
            Token token2 = null;
            Iterator iterator2 = bagOfTokens2.tokenIterator();
            while (iterator2.hasNext()) {
                Token token3 = (Token)iterator2.next();
                double d3 = this.tokenDistance.score(token.getValue(), token3.getValue());
                stringBuffer.append(" dist(" + token3.getValue() + ")=" + d3);
                if (!(d3 >= d2)) continue;
                d2 = d3;
                token2 = token3;
            }
            d += d2;
            stringBuffer.append(" match=" + token2 + " score=" + d2 + "\n");
        }
        stringBuffer.append("total: " + d + "/" + bagOfTokens.size() + " = " + this.score(stringWrapper, stringWrapper2) + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return "[Level2:tokenizer=" + this.tokenizer + ";tokenDist=" + this.tokenDistance + "]";
    }

    public static void main(String[] stringArray) {
        AbstractStringDistance.doMain(new Level2(SimpleTokenizer.DEFAULT_TOKENIZER, new Levenstein()), stringArray);
    }
}

