/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class JensenShannonDistance
extends AbstractStringDistance {
    private Tokenizer tokenizer;
    private Map backgroundFrequency = new HashMap();
    int totalTokens = 0;
    private static final Integer ONE = new Integer(1);
    private static final Integer TWO = new Integer(2);
    private static final Integer THREE = new Integer(3);

    public JensenShannonDistance(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public JensenShannonDistance() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER);
    }

    public final void accumulateStatistics(Iterator iterator) {
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            StringWrapper stringWrapper = (StringWrapper)iterator.next();
            Token[] tokenArray = this.tokenizer.tokenize(stringWrapper.unwrap());
            int n = 0;
            while (n < tokenArray.length) {
                ++this.totalTokens;
                Integer n2 = (Integer)this.backgroundFrequency.get(tokenArray[n]);
                if (n2 == null) {
                    this.backgroundFrequency.put(tokenArray[n], ONE);
                } else if (n2 == ONE) {
                    this.backgroundFrequency.put(tokenArray[n], TWO);
                } else if (n2 == TWO) {
                    this.backgroundFrequency.put(tokenArray[n], THREE);
                } else {
                    this.backgroundFrequency.put(tokenArray[n], new Integer(n2 + 1));
                }
                ++n;
            }
        }
    }

    public final StringWrapper prepare(String string) {
        BagOfTokens bagOfTokens = new BagOfTokens(string, this.tokenizer.tokenize(string));
        double d = bagOfTokens.getTotalWeight();
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            double d2 = bagOfTokens.getWeight(token);
            bagOfTokens.setWeight(token, this.smoothedProbability(token, d2, d));
        }
        return bagOfTokens;
    }

    protected abstract double smoothedProbability(Token var1, double var2, double var4);

    protected double backgroundProb(Token token) {
        Integer n = (Integer)this.backgroundFrequency.get(token);
        double d = n == null ? 0.0 : (double)n.intValue();
        return d / (double)this.totalTokens;
    }

    public final double score(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        double d = 0.0;
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (!bagOfTokens2.contains(token)) continue;
            double d2 = bagOfTokens.getWeight(token);
            double d3 = bagOfTokens2.getWeight(token);
            d -= this.h(d2 + d3) - this.h(d2) - this.h(d3);
        }
        return 0.5 * d / Math.log(2.0);
    }

    private double h(double d) {
        return -d * Math.log(d);
    }

    public final String explainScore(StringWrapper stringWrapper, StringWrapper stringWrapper2) {
        StringBuffer stringBuffer = new StringBuffer();
        PrintfFormat printfFormat = new PrintfFormat("%.3f");
        BagOfTokens bagOfTokens = (BagOfTokens)stringWrapper;
        BagOfTokens bagOfTokens2 = (BagOfTokens)stringWrapper2;
        stringBuffer.append("Common tokens: ");
        Iterator iterator = bagOfTokens.tokenIterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (!bagOfTokens2.contains(token)) continue;
            double d = bagOfTokens.getWeight(token);
            double d2 = bagOfTokens2.getWeight(token);
            stringBuffer.append(" " + token.getValue() + ": ");
            stringBuffer.append(printfFormat.sprintf(d));
            stringBuffer.append("*");
            stringBuffer.append(printfFormat.sprintf(d2));
            stringBuffer.append(":delta=");
            stringBuffer.append(printfFormat.sprintf(this.h(d + d2) - this.h(d) - this.h(d2)));
        }
        stringBuffer.append("\nscore = " + this.score(stringWrapper, stringWrapper2));
        return stringBuffer.toString();
    }
}

