/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.AbstractStringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.tokens.SimpleTokenizer;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractStatisticalTokenDistance
extends AbstractStringDistance {
    protected Tokenizer tokenizer;
    protected Map documentFrequency = new HashMap();
    private static final Integer ONE = new Integer(1);
    private static final Integer TWO = new Integer(2);
    private static final Integer THREE = new Integer(3);
    protected int collectionSize = 0;
    protected int totalTokenCount = 0;

    public AbstractStatisticalTokenDistance(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public AbstractStatisticalTokenDistance() {
        this(SimpleTokenizer.DEFAULT_TOKENIZER);
    }

    public void accumulateStatistics(Iterator iterator) {
        HashSet<Token> hashSet = new HashSet<Token>();
        while (iterator.hasNext()) {
            StringWrapper stringWrapper = (StringWrapper)iterator.next();
            Token[] tokenArray = this.tokenizer.tokenize(stringWrapper.unwrap());
            hashSet.clear();
            int n = 0;
            while (n < tokenArray.length) {
                ++this.totalTokenCount;
                if (!hashSet.contains(tokenArray[n])) {
                    hashSet.add(tokenArray[n]);
                    Integer n2 = (Integer)this.documentFrequency.get(tokenArray[n]);
                    if (n2 == null) {
                        this.documentFrequency.put(tokenArray[n], ONE);
                    } else if (n2 == ONE) {
                        this.documentFrequency.put(tokenArray[n], TWO);
                    } else if (n2 == TWO) {
                        this.documentFrequency.put(tokenArray[n], THREE);
                    } else {
                        this.documentFrequency.put(tokenArray[n], new Integer(n2 + 1));
                    }
                }
                ++n;
            }
            ++this.collectionSize;
        }
    }

    public int getDocumentFrequency(Token token) {
        Integer n = (Integer)this.documentFrequency.get(token);
        if (n == null) {
            return 0;
        }
        return n;
    }
}

