/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.Platform;

import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSMenu;
import com.apple.cocoa.application.NSMenuItem;
import com.apple.cocoa.foundation.NSObject;
import com.apple.cocoa.foundation.NSSelector;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.apple.eio.FileManager;
import com.kfu.JXM.Bookmark;
import com.kfu.JXM.Favorite;
import com.kfu.JXM.IPlatformCallbackHandler;
import com.kfu.JXM.IPlatformHandler;
import com.kfu.xm.ChannelInfo;
import java.io.IOException;

public class MacOSX
implements IPlatformHandler {
    private IPlatformCallbackHandler cb;
    ChannelInfo menuInfo;

    private static native String getBundleNameForDevice(String var0);

    public boolean useMacMenus() {
        return true;
    }

    public boolean needsBrowserPath() {
        return false;
    }

    public void setBrowserPath(String string) {
        throw new IllegalArgumentException("We don't care");
    }

    public void openURL(String string) throws IOException {
        FileManager.openURL((String)string);
    }

    public void registerCallbackHandler(IPlatformCallbackHandler iPlatformCallbackHandler) {
        this.cb = iPlatformCallbackHandler;
    }

    public boolean devicesAreFiltered() {
        return true;
    }

    public boolean isDeviceValid(String string) {
        if (!string.startsWith("/dev/tty.")) {
            return false;
        }
        String string2 = MacOSX.getBundleNameForDevice(string);
        return string2 != null && string2.startsWith("com.FTDI.");
    }

    public MacOSX() throws Exception {
        if (System.getProperty("mrj.version") == null) {
            throw new Exception("This isn't a macintosh");
        }
        Application application = new Application();
        application.addAboutMenuItem();
        application.setEnabledAboutMenu(true);
        application.addPreferencesMenuItem();
        application.setEnabledPreferencesMenu(true);
        application.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent applicationEvent) {
                MacOSX.this.cb.platformNotify(1, null);
                applicationEvent.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent applicationEvent) {
                MacOSX.this.cb.platformNotify(0, null);
                applicationEvent.setHandled(true);
            }

            public void handleQuit(ApplicationEvent applicationEvent) {
                MacOSX.this.cb.platformNotify(2, null);
                applicationEvent.setHandled(true);
            }
        });
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JXM");
        NSApplication.sharedApplication().setDelegate((Object)this);
    }

    public NSMenu applicationDockMenu(NSApplication nSApplication) {
        int n;
        NSMenuItem nSMenuItem;
        if (!this.cb.radioIsOn()) {
            return null;
        }
        NSMenu nSMenu = new NSMenu();
        this.menuInfo = this.cb.getChannelInfo();
        if (this.menuInfo != null) {
            nSMenuItem = new NSMenuItem(Integer.toString(this.menuInfo.getChannelNumber()) + " - " + this.menuInfo.getChannelName(), null, "");
            nSMenu.addItem(nSMenuItem);
            nSMenuItem = new NSMenuItem(this.menuInfo.getChannelArtist(), null, "");
            nSMenu.addItem(nSMenuItem);
            nSMenuItem = new NSMenuItem(this.menuInfo.getChannelTitle(), null, "");
            nSMenu.addItem(nSMenuItem);
        }
        nSMenuItem = new NSMenuItem().separatorItem();
        nSMenu.addItem(nSMenuItem);
        Bookmark[] bookmarkArray = this.cb.getBookmarks();
        NSMenu nSMenu2 = new NSMenu("Bookmarks");
        for (int i = 0; i < bookmarkArray.length; ++i) {
            nSMenuItem = new NSMenuItem(bookmarkArray[i].getName(), new NSSelector("bookmarkMenuClicked", new Class[]{class$com$apple$cocoa$foundation$NSObject == null ? MacOSX.class$("com.apple.cocoa.foundation.NSObject") : class$com$apple$cocoa$foundation$NSObject}), "");
            nSMenuItem.setTarget((Object)this);
            nSMenuItem.setRepresentedObject((Object)bookmarkArray[i]);
            nSMenu2.addItem(nSMenuItem);
        }
        nSMenuItem = new NSMenuItem("Bookmarks", null, "");
        nSMenu.addItem(nSMenuItem);
        nSMenu.setSubmenuForItem(nSMenu2, nSMenuItem);
        nSMenuItem = new NSMenuItem().separatorItem();
        nSMenu.addItem(nSMenuItem);
        Favorite[] favoriteArray = this.cb.getFavorites();
        NSMenu nSMenu3 = new NSMenu("Favorites");
        for (n = 0; n < favoriteArray.length; ++n) {
            nSMenuItem = new NSMenuItem(favoriteArray[n].getMenuString(), new NSSelector("favoriteMenuClicked", new Class[]{class$com$apple$cocoa$foundation$NSObject == null ? MacOSX.class$("com.apple.cocoa.foundation.NSObject") : class$com$apple$cocoa$foundation$NSObject}), "");
            nSMenuItem.setTarget((Object)this);
            nSMenuItem.setRepresentedObject((Object)new Integer(favoriteArray[n].getChannelNumber()));
            nSMenu3.addItem(nSMenuItem);
        }
        nSMenuItem = new NSMenuItem("Favorites", null, "");
        nSMenu.addItem(nSMenuItem);
        nSMenu.setSubmenuForItem(nSMenu3, nSMenuItem);
        nSMenuItem = new NSMenuItem().separatorItem();
        nSMenu.addItem(nSMenuItem);
        nSMenuItem = new NSMenuItem("Add to notebook", new NSSelector("memoryMenuClicked", new Class[]{NSObject.class}), "");
        nSMenuItem.setTarget((Object)this);
        nSMenu.addItem(nSMenuItem);
        nSMenuItem = new NSMenuItem().separatorItem();
        nSMenu.addItem(nSMenuItem);
        n = this.cb.getMuteState();
        nSMenuItem = new NSMenuItem("Mute", new NSSelector("normMuteClicked", new Class[]{NSObject.class}), "");
        nSMenuItem.setTarget((Object)this);
        nSMenuItem.setState(n == 1 ? 1 : 0);
        nSMenu.addItem(nSMenuItem);
        nSMenuItem = new NSMenuItem("Smart Mute", new NSSelector("smartMuteClicked", new Class[]{NSObject.class}), "");
        nSMenuItem.setTarget((Object)this);
        nSMenuItem.setState(n == 2 ? 1 : 0);
        nSMenu.addItem(nSMenuItem);
        return nSMenu;
    }

    public void applicationShouldTerminate(NSObject nSObject) {
        this.cb.platformNotify(2, null);
    }

    public void normMuteClicked(NSObject nSObject) {
        this.cb.platformNotify(4, null);
    }

    public void smartMuteClicked(NSObject nSObject) {
        this.cb.platformNotify(3, null);
    }

    public void bookmarkMenuClicked(NSObject nSObject) {
        NSMenuItem nSMenuItem = (NSMenuItem)nSObject;
        Bookmark bookmark = (Bookmark)nSMenuItem.representedObject();
        this.menuInfo = this.menuInfo;
        if (this.menuInfo == null) {
            return;
        }
        try {
            bookmark.surf(this.menuInfo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void favoriteMenuClicked(NSObject nSObject) {
        NSMenuItem nSMenuItem = (NSMenuItem)nSObject;
        Integer n = (Integer)nSMenuItem.representedObject();
        this.cb.platformNotify(5, n);
    }

    public void memoryMenuClicked(NSObject nSObject) {
        this.cb.platformNotify(6, this.menuInfo);
    }

    public void quit() {
    }

    static {
        System.loadLibrary("MacOSX");
    }
}

