/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.JXM;

import com.kfu.JXM.JXM;
import com.kfu.JXM.TrackerException;
import com.kfu.xm.ChannelInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class XMTracker {
    private static XMTracker myTracker;
    private int lastChannel = -1;
    private String lastArtist = null;
    private String lastTitle = null;
    private String username;
    private String password;
    private boolean enabled = false;
    private String baseURL = "http://www.xmnation.net/tracker/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMTracker theTracker() {
        Class clazz = XMTracker.class;
        synchronized (clazz) {
            if (myTracker == null) {
                myTracker = new XMTracker();
            }
        }
        return myTracker;
    }

    public void Disable() {
        this.enabled = false;
        this.lastChannel = -1;
    }

    public boolean getState() {
        return this.enabled;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    public void setCredentials(String string, String string2) throws TrackerException {
        this.username = string;
        this.password = string2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.baseURL);
        stringBuffer.append("auth.php?username=");
        try {
            stringBuffer.append(URLEncoder.encode(string, "US-ASCII"));
            stringBuffer.append("&password=");
            stringBuffer.append(URLEncoder.encode(string2, "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TrackerException("How is US-ASCII an unsupported encoding?");
        }
        try {
            URL uRL = new URL(stringBuffer.toString());
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", JXM.userAgentString());
            boolean bl = this.getResponse(uRLConnection.getInputStream());
            if (!bl) {
                throw new TrackerException("Your username and/or password are not correct");
            }
        }
        catch (IOException iOException) {
            throw new TrackerException(iOException.getMessage());
        }
        this.enabled = true;
    }

    private boolean getResponse(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            return string.equals("yep");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void update(ChannelInfo channelInfo) throws TrackerException {
        if (!this.enabled || channelInfo == null || channelInfo.getChannelNumber() == this.lastChannel && channelInfo.getChannelArtist().equals(this.lastArtist) && channelInfo.getChannelTitle().equals(this.lastTitle)) {
            return;
        }
        this.lastChannel = channelInfo.getChannelNumber();
        this.lastArtist = channelInfo.getChannelArtist();
        this.lastTitle = channelInfo.getChannelTitle();
        this.update(Integer.toString(this.lastChannel), this.lastArtist, this.lastTitle);
    }

    public void turnOff() throws TrackerException {
        if (!this.enabled) {
            return;
        }
        this.update("OFF", "", "");
        this.lastChannel = -1;
    }

    private void update(String string, String string2, String string3) throws TrackerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.baseURL);
        stringBuffer.append("now.php?");
        stringBuffer.append("u=");
        try {
            stringBuffer.append(URLEncoder.encode(this.username, "US-ASCII"));
            stringBuffer.append("&p=");
            stringBuffer.append(URLEncoder.encode(this.password, "US-ASCII"));
            stringBuffer.append("&c=");
            stringBuffer.append(URLEncoder.encode(string, "US-ASCII"));
            stringBuffer.append("&a=");
            stringBuffer.append(URLEncoder.encode(string2, "US-ASCII"));
            stringBuffer.append("&t=");
            stringBuffer.append(URLEncoder.encode(string3, "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TrackerException("I'm confused. How is US-ASCII an unsupported encoding?");
        }
        try {
            URL uRL = new URL(stringBuffer.toString());
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", JXM.userAgentString());
            uRLConnection.getContent();
        }
        catch (IOException iOException) {
            throw new TrackerException(iOException.getMessage());
        }
    }
}

