/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.JXM;

import com.kfu.JXM.Bookmark;
import com.kfu.JXM.IPreferenceCallbackHandler;
import com.kfu.JXM.JXM;
import com.kfu.JXM.PlatformFactory;
import com.kfu.JXM.TrackerException;
import com.kfu.JXM.XMTracker;
import com.kfu.xm.ChannelInfo;
import com.kfu.xm.RadioCommander;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreferencesDialog
extends JDialog {
    private JTabbedPane theTabs;
    private JComboBox deviceMenu;
    private JCheckBox deviceIsXmDirect;
    private JLabel radioID;
    private JTextField trackerURL;
    private JTextField trackerUser;
    private JPasswordField trackerPassword;
    private JCheckBox trackerEnabled;
    private JTextField browserPath = null;
    private IPreferenceCallbackHandler handler;
    private DefaultListModel bookmarks = new DefaultListModel();
    private JList bookmarkList;
    private JButton bookmarkDelButton;
    private JTextField bmName;
    private JTextField bmURL;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JCheckBox startupCheckbox;
    private JComboBox sleepAction;
    private JSlider searchAccuracy;
    String[] sleepActions = new String[]{"Mute Radio Volume", "Turn Radio Off", "Quit JXM Program"};
    static final int SLEEP_MUTE = 0;
    static final int SLEEP_OFF = 1;
    static final int SLEEP_QUIT = 2;
    static final int SLEEP_MAX = 2;
    public static final int TAB_DEVICE = 0;
    public static final int TAB_TRACKER = 1;
    public static final int TAB_BOOKMARKS = 2;
    public static final int TAB_FILTERS = 3;
    public static final int TAB_SEARCH = 4;
    public static final int TAB_MISC = 5;
    static final String STARTUP_CHECK = "StartupVersionCheck";
    private static final String SLEEP_ACTION = "SleepAction";
    private static final String SEARCH_ACCURACY = "SearchAccuracy";
    private static final String XMTRACKER_URL = "TrackerURL";
    private static final String XMTRACKER_USER = "TrackerUser";
    private static final String XMTRACKER_PASS = "TrackerPassword";
    private static final String XMTRACKER_ENABLED = "TrackerEnabled";
    private static final String BROWSER_PATH = "BrowserPath";
    private static final String BOOKMARKS = "Bookmarks";
    private String[][] defaultBookMarks = new String[][]{{"Channel Home Page", "http://www.xmradio.com/programming/channel_page.jsp?ch={NUMBER}"}, {"Channel Guide Page", "http://www.xmradio.com/programming/channel_guide.jsp?ch={NUMBER}"}, {"View song ratings for channel", "http://xmpcr.kfu.com/ratings.php?channel={NUMBER}"}, {"Forum for Channel", "http://xmpcr.kfu.com/forums/forum_for_channel.php?ch={NUMBER}"}, {"Google search for Artist", "http://www.google.com/search?q=%22{ARTIST}%22"}, {"Google search for Title", "http://www.google.com/search?q=%22{TITLE}%22"}, {"Google search for Artist and Title", "http://www.google.com/search?q=%22{ARTIST}%22+%22{TITLE}%22"}, {"iTunes search for Artist", "itms://phobos.apple.com/WebObjects/MZSearch.woa/wa/com.apple.jingle.search.DirectAction/advancedSearchResults?artistTerm={ARTIST}"}, {"iTunes search for Artist and Title", "itms://phobos.apple.com/WebObjects/MZSearch.woa/wa/com.apple.jingle.search.DirectAction/advancedSearchResults?artistTerm={ARTIST}&songTerm={TITLE}"}};
    private static final String DEVICE_NAME_KEY = "DefaultDevice";
    private static final String DEVICE_IS_XMDIRECT_KEY = "DeviceIsXmDirect";

    public void setVisible(boolean bl) {
        if (bl) {
            this.reloadFromDefaults();
        }
        super.setVisible(bl);
    }

    public void showTab(int n) {
        this.theTabs.setSelectedIndex(n);
        this.setVisible(true);
    }

    public void addNewSongSearch(ChannelInfo channelInfo) {
        this.reloadFromDefaults();
        this.theTabs.setSelectedIndex(4);
        this.handler.getSearchSystem().addNewSong(channelInfo);
        super.setVisible(true);
    }

    public PreferencesDialog(JFrame jFrame, IPreferenceCallbackHandler iPreferenceCallbackHandler) {
        super(jFrame, "JXM Preferences", true);
        JList<Object> jList;
        this.handler = iPreferenceCallbackHandler;
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.theTabs = new JTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel();
        this.deviceMenu = new JComboBox();
        jPanel2.add(this.deviceMenu);
        this.deviceIsXmDirect = new JCheckBox("XM Direct");
        this.deviceIsXmDirect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.refreshDeviceMenu();
            }
        });
        jPanel2.add(this.deviceIsXmDirect);
        this.deviceIsXmDirect.setSelected(JXM.myUserNode().getBoolean(DEVICE_IS_XMDIRECT_KEY, false));
        this.refreshDeviceMenu();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 20;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel("Radio ID:");
        jPanel2.add(jLabel);
        this.radioID = new JLabel(" ");
        this.radioID.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.radioID.setHorizontalAlignment(0);
        this.radioID.setFont(new Font("Monospaced", 0, 20));
        this.radioID.setPreferredSize(new Dimension(150, (int)this.radioID.getPreferredSize().getHeight()));
        jPanel2.add(this.radioID);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 19;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.theTabs.insertTab("Device", null, jPanel, null, 0);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.anchor = 22;
        jLabel = new JLabel("Base URL:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jLabel = new JLabel("Username:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel("Password:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.trackerURL = new JTextField();
        this.trackerURL.setPreferredSize(new Dimension(250, (int)this.trackerURL.getPreferredSize().getHeight()));
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)this.trackerURL, gridBagConstraints);
        this.trackerUser = new JTextField();
        this.trackerUser.setPreferredSize(new Dimension(100, (int)this.trackerUser.getPreferredSize().getHeight()));
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.trackerUser, gridBagConstraints);
        this.trackerPassword = new JPasswordField();
        this.trackerPassword.setEchoChar('\u2022');
        this.trackerPassword.setPreferredSize(new Dimension(100, (int)this.trackerPassword.getPreferredSize().getHeight()));
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.trackerPassword, gridBagConstraints);
        this.trackerEnabled = new JCheckBox("Enable XM Tracker");
        this.trackerEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.trackerCheckboxClicked();
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.trackerEnabled, gridBagConstraints);
        this.theTabs.insertTab("XM Tracker", null, jPanel, null, 1);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this.bookmarkList = jList = new JList<Object>();
        jList.setSelectionMode(0);
        jList.setLayoutOrientation(0);
        jList.setVisibleRowCount(5);
        jList.setModel(this.bookmarks);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = PreferencesDialog.this.bookmarkList.getSelectedIndex();
                PreferencesDialog.this.bookmarkDelButton.setEnabled(n >= 0);
                PreferencesDialog.this.moveUpButton.setEnabled(n >= 1);
                PreferencesDialog.this.moveDownButton.setEnabled(n >= 0 && n < PreferencesDialog.this.bookmarks.size() - 1);
                PreferencesDialog.this.bmName.setEnabled(n >= 0);
                PreferencesDialog.this.bmURL.setEnabled(n >= 0);
                if (n < 0) {
                    PreferencesDialog.this.bmName.setText("");
                    PreferencesDialog.this.bmURL.setText("");
                    return;
                }
                Bookmark bookmark = (Bookmark)PreferencesDialog.this.bookmarkList.getSelectedValue();
                PreferencesDialog.this.bmName.setText(bookmark.getName());
                PreferencesDialog.this.bmURL.setText(bookmark.getURL());
            }
        });
        jList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = ((Bookmark)object).getName();
                if (string == null || string == "") {
                    string = " ";
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JScrollPane(jList), gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("+");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PreferencesDialog.this.bookmarkList.getSelectedIndex();
                if (n < 0) {
                    PreferencesDialog.this.bookmarks.add(PreferencesDialog.this.bookmarks.size(), new Bookmark("", ""));
                } else {
                    Bookmark bookmark = (Bookmark)PreferencesDialog.this.bookmarks.get(n);
                    PreferencesDialog.this.bookmarks.add(PreferencesDialog.this.bookmarks.size(), new Bookmark("copy of " + bookmark.getName(), bookmark.getURL()));
                }
                PreferencesDialog.this.bookmarkList.setSelectedIndex(PreferencesDialog.this.bookmarks.size() - 1);
                PreferencesDialog.this.bookmarkList.ensureIndexIsVisible(PreferencesDialog.this.bookmarks.size() - 1);
            }
        });
        jPanel3.add(jButton);
        this.bookmarkDelButton = new JButton("-");
        this.bookmarkDelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PreferencesDialog.this.bookmarkList.getSelectedIndex();
                PreferencesDialog.this.bookmarks.remove(n);
                PreferencesDialog.this.bookmarkList.setSelectedIndex(-1);
            }
        });
        this.bookmarkDelButton.setEnabled(false);
        jPanel3.add(this.bookmarkDelButton);
        this.moveUpButton = new JButton("move up");
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PreferencesDialog.this.bookmarkList.getSelectedIndex();
                Bookmark bookmark = (Bookmark)PreferencesDialog.this.bookmarks.remove(n);
                PreferencesDialog.this.bookmarks.add(n - 1, bookmark);
                PreferencesDialog.this.bookmarkList.setSelectedIndex(n - 1);
                PreferencesDialog.this.bookmarkList.ensureIndexIsVisible(n - 1);
            }
        });
        jPanel3.add(this.moveUpButton);
        this.moveDownButton = new JButton("move down");
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PreferencesDialog.this.bookmarkList.getSelectedIndex();
                Bookmark bookmark = (Bookmark)PreferencesDialog.this.bookmarks.remove(n);
                PreferencesDialog.this.bookmarks.add(n + 1, bookmark);
                PreferencesDialog.this.bookmarkList.setSelectedIndex(n + 1);
                PreferencesDialog.this.bookmarkList.ensureIndexIsVisible(n + 1);
            }
        });
        jPanel3.add(this.moveDownButton);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        jLabel = new JLabel("Name: ");
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 22;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.bmName = new JTextField();
        this.bmName.setEnabled(false);
        this.bmName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            private void doIt() {
                int n = PreferencesDialog.this.bookmarkList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                Bookmark bookmark = (Bookmark)PreferencesDialog.this.bookmarks.get(n);
                bookmark.setName(PreferencesDialog.this.bmName.getText());
                PreferencesDialog.this.bookmarks.set(n, bookmark);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.bmName, gridBagConstraints);
        jLabel = new JLabel("URL: ");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.bmURL = new JTextField();
        this.bmURL.setEnabled(false);
        this.bmURL.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            private void doIt() {
                int n = PreferencesDialog.this.bookmarkList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                Bookmark bookmark = (Bookmark)PreferencesDialog.this.bookmarks.get(n);
                bookmark.setURL(PreferencesDialog.this.bmURL.getText());
                PreferencesDialog.this.bookmarks.set(n, bookmark);
            }
        });
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.bmURL, gridBagConstraints);
        jLabel = new JLabel("<html><center><b>URL tokens:</b><table><tr><td>{NUMBER}</td><td>Channel number</td></tr><tr><td>{GENRE}</td><td>Channel Genre</td></tr><tr><td>{NAME}</td><td>Channel Name</td></tr><tr><td>{ARTIST}</td><td>Artist currently playing on Channel</td></tr><tr><td>{TITLE}</td><td>Song title currently playing on Channel</td></tr><tr><td>{SERVICE}</td><td>Channel Service ID</td></tr></table></center></html>");
        jLabel.setFont(new Font(null, 0, 10));
        jLabel.setMinimumSize(new Dimension(300, 150));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.theTabs.insertTab("Web Bookmarks", null, jPanel, null, 2);
        this.theTabs.insertTab("Filters", null, this.handler.getFilterPreferencePanel(), null, 3);
        this.theTabs.setEnabledAt(3, false);
        this.theTabs.insertTab("Search", null, this.handler.getSearchPreferencePanel(), null, 4);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        if (PlatformFactory.ourPlatform().needsBrowserPath()) {
            jLabel = new JLabel("Path to Browser: ");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 22;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.browserPath = new JTextField();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.browserPath, gridBagConstraints);
        }
        JButton jButton2 = new JButton("Clear channel use statistics");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.handler.clearChannelStats();
            }
        });
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.startupCheckbox = new JCheckBox("Check for new version at startup");
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.startupCheckbox, gridBagConstraints);
        jLabel = new JLabel("When sleep timer expires: ");
        jLabel.setHorizontalAlignment(11);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.sleepAction = new JComboBox<String>(this.sleepActions);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.sleepAction, gridBagConstraints);
        jLabel = new JLabel("search accuracy");
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.searchAccuracy = new JSlider();
        this.searchAccuracy.setMinimum(500);
        this.searchAccuracy.setMaximum(1000);
        this.searchAccuracy.setMajorTickSpacing(500);
        this.searchAccuracy.setMinorTickSpacing(100);
        this.searchAccuracy.setPaintTicks(true);
        this.searchAccuracy.setSnapToTicks(false);
        this.searchAccuracy.setValue(900);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.searchAccuracy, gridBagConstraints);
        jLabel = new JLabel("loose");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("tight");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 22;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.theTabs.insertTab("Misc", null, jPanel, null, 5);
        this.getContentPane().add((Component)this.theTabs, "Center");
        jPanel = new JPanel();
        JButton jButton3 = new JButton("Cancel");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.reloadFromDefaults();
                PreferencesDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton3);
        jButton3 = new JButton("OK");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.saveToDefaults();
                PreferencesDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton3);
        this.getContentPane().add((Component)jPanel, "Last");
        this.reloadFromDefaults();
        this.doBookmarkRebuild();
        this.pack();
    }

    private void trackerCheckboxClicked() {
        boolean bl = this.trackerEnabled.isSelected();
        if (bl) {
            try {
                XMTracker.theTracker().setBaseURL(this.trackerURL.getText());
                XMTracker.theTracker().setCredentials(this.trackerUser.getText(), new String(this.trackerPassword.getPassword()));
                this.trackerURL.setEnabled(false);
                this.trackerUser.setEnabled(false);
                this.trackerPassword.setEnabled(false);
                this.trackerEnabled.setSelected(true);
            }
            catch (TrackerException trackerException) {
                this.trackerEnabled.setSelected(false);
                JXM.myUserNode().putBoolean(XMTRACKER_ENABLED, false);
                this.handleTrackerException(trackerException);
            }
        } else {
            this.trackerURL.setEnabled(true);
            this.trackerUser.setEnabled(true);
            this.trackerPassword.setEnabled(true);
            this.trackerEnabled.setSelected(false);
            try {
                XMTracker.theTracker().turnOff();
            }
            catch (TrackerException trackerException) {
                this.handleTrackerException(trackerException);
                return;
            }
            XMTracker.theTracker().Disable();
        }
    }

    private void reloadFromDefaults() {
        String[] stringArray;
        Preferences preferences;
        block13: {
            this.handler.reload();
            this.startupCheckbox.setSelected(JXM.myUserNode().getBoolean(STARTUP_CHECK, true));
            int n = JXM.myUserNode().getInt(SLEEP_ACTION, 0);
            if (n < 0 || n > 2) {
                n = 0;
            }
            this.sleepAction.setSelectedIndex(n);
            n = JXM.myUserNode().getInt(SEARCH_ACCURACY, 900);
            if (n < 500 || n > 1000) {
                n = 900;
            }
            this.searchAccuracy.setValue(n);
            try {
                if (JXM.myUserNode().nodeExists(BOOKMARKS)) break block13;
                preferences = JXM.myUserNode().node(BOOKMARKS);
                for (int i = 0; i < this.defaultBookMarks.length; ++i) {
                    String string;
                    try {
                        string = URLEncoder.encode(this.defaultBookMarks[i][0], "US-ASCII") + ":" + URLEncoder.encode(this.defaultBookMarks[i][1], "US-ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        continue;
                    }
                    preferences.put(Integer.toString(i), string);
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        preferences = JXM.myUserNode().node(BOOKMARKS);
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            stringArray = new String[]{};
        }
        Arrays.sort(stringArray, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    int n = Integer.parseInt(object.toString());
                    int n2 = Integer.parseInt(object2.toString());
                    return new Integer(n).compareTo(new Integer(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
        });
        this.bookmarks.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String[] stringArray2 = preferences.get(stringArray[i], "").split(":", -1);
            if (stringArray2.length != 2) continue;
            try {
                string2 = URLDecoder.decode(stringArray2[0], "US-ASCII");
                string = URLDecoder.decode(stringArray2[1], "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                continue;
            }
            Bookmark bookmark = new Bookmark(string2, string);
            this.bookmarks.add(this.bookmarks.getSize(), bookmark);
        }
        this.trackerURL.setText(JXM.myUserNode().get(XMTRACKER_URL, "http://xmpcr.kfu.com/forums/tracker/"));
        this.trackerUser.setText(JXM.myUserNode().get(XMTRACKER_USER, ""));
        this.trackerPassword.setText(JXM.myUserNode().get(XMTRACKER_PASS, ""));
        this.trackerEnabled.setSelected(JXM.myUserNode().getBoolean(XMTRACKER_ENABLED, false));
        this.trackerCheckboxClicked();
        if (this.browserPath != null) {
            this.browserPath.setText(JXM.myUserNode().get(BROWSER_PATH, ""));
            PlatformFactory.ourPlatform().setBrowserPath(this.browserPath.getText());
        }
    }

    private void saveToDefaults() {
        this.handler.save();
        JXM.myUserNode().putBoolean(STARTUP_CHECK, this.startupCheckbox.isSelected());
        JXM.myUserNode().putInt(SLEEP_ACTION, this.sleepAction.getSelectedIndex());
        JXM.myUserNode().putInt(SEARCH_ACCURACY, this.searchAccuracy.getValue());
        Preferences preferences = JXM.myUserNode().node(BOOKMARKS);
        try {
            preferences.clear();
            for (int i = 0; i < this.bookmarks.getSize(); ++i) {
                String string;
                Bookmark bookmark = (Bookmark)this.bookmarks.getElementAt(i);
                try {
                    string = URLEncoder.encode(bookmark.getName(), "US-ASCII") + ":" + URLEncoder.encode(bookmark.getURL(), "US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    continue;
                }
                preferences.put(Integer.toString(i), string);
            }
            this.doBookmarkRebuild();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        JXM.myUserNode().put(XMTRACKER_URL, this.trackerURL.getText());
        JXM.myUserNode().put(XMTRACKER_USER, this.trackerUser.getText());
        JXM.myUserNode().put(XMTRACKER_PASS, new String(this.trackerPassword.getPassword()));
        JXM.myUserNode().putBoolean(XMTRACKER_ENABLED, this.trackerEnabled.isSelected());
        if (this.browserPath != null) {
            JXM.myUserNode().put(BROWSER_PATH, this.browserPath.getText());
            PlatformFactory.ourPlatform().setBrowserPath(this.browserPath.getText());
        }
    }

    private void doBookmarkRebuild() {
        Object[] objectArray = this.bookmarks.toArray();
        Bookmark[] bookmarkArray = new Bookmark[objectArray.length];
        System.arraycopy(objectArray, 0, bookmarkArray, 0, objectArray.length);
        this.handler.rebuildBookmarksMenu(bookmarkArray);
    }

    public void turnOn(String string) {
        this.radioID.setText(string);
        this.deviceMenu.setEnabled(false);
        this.deviceIsXmDirect.setEnabled(false);
        this.theTabs.setEnabledAt(3, true);
    }

    public void turnOff() {
        this.radioID.setText("");
        this.deviceMenu.setEnabled(true);
        this.deviceIsXmDirect.setEnabled(true);
        if (this.theTabs.getSelectedIndex() == 3) {
            this.theTabs.setSelectedIndex(0);
        }
        this.theTabs.setEnabledAt(3, false);
    }

    private void handleTrackerException(Exception exception) {
        JOptionPane.showMessageDialog(this, exception.getMessage(), "XM Tracker error", 0);
    }

    private void refreshDeviceMenu() {
        this.deviceMenu.removeAllItems();
        this.deviceMenu.addItem("Pick device");
        String[] stringArray = RadioCommander.getPotentialDevices();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!this.deviceIsXmDirect.isSelected() && !PlatformFactory.ourPlatform().isDeviceValid(string)) continue;
            this.deviceMenu.addItem(string);
        }
        this.deviceMenu.setSelectedItem(JXM.myUserNode().get(DEVICE_NAME_KEY, ""));
        if (this.deviceMenu.getSelectedIndex() <= 0) {
            if (PlatformFactory.ourPlatform().devicesAreFiltered() && this.deviceMenu.getItemCount() == 2) {
                this.deviceMenu.setSelectedIndex(1);
            } else {
                this.deviceMenu.setSelectedIndex(0);
            }
        }
    }

    public String getDevice() {
        String string = (String)this.deviceMenu.getSelectedItem();
        if (string == "" | string == "Pick device") {
            return null;
        }
        return string;
    }

    public boolean isDeviceXmDirect() {
        return this.deviceIsXmDirect.isSelected();
    }

    public void saveDevice() {
        JXM.myUserNode().put(DEVICE_NAME_KEY, (String)this.deviceMenu.getSelectedItem());
        JXM.myUserNode().putBoolean(DEVICE_IS_XMDIRECT_KEY, this.deviceIsXmDirect.isSelected());
    }

    public int getSleepAction() {
        return this.sleepAction.getSelectedIndex();
    }

    public String getTrackerURL() {
        return this.trackerURL.getText();
    }

    public String getTrackerUser() {
        return this.trackerUser.getText();
    }

    public String getTrackerPassword() {
        return new String(this.trackerPassword.getPassword());
    }

    public double getSearchAccuracy() {
        return (float)this.searchAccuracy.getValue() / 1000.0f;
    }

    public boolean isTrackerEnabled() {
        return this.trackerEnabled.isSelected();
    }
}

