/*
 * Decompiled with CFR 0.152.
 */
package com.kfu.JXM;

import com.kfu.JXM.JXM;
import com.kfu.JXM.MainWindow;
import com.kfu.xm.ChannelInfo;
import com.kfu.xm.RadioCommander;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterPanel
extends JPanel {
    ArrayList filterSets = new ArrayList();
    int currentFilterIndex = -1;
    private MainWindow parent;
    private JTabbedPane theTabbedPane;
    private JPanel tabContents;
    private JTree theTree;
    private JTextField filterNameField;
    private JButton deleteButton;
    private JComboBox filterMenu;
    private boolean ignoreFilterMenu = false;
    private static final String FILTER_SET_KEY = "FilterSets";
    private static final String FILTER_SET_ORDER = "FilterSetOrder";
    private static final String DEFAULT_FILTER_KEY = "DefaultFilter";

    private Filter currentFilter() {
        return (Filter)this.filterSets.get(this.currentFilterIndex);
    }

    public FilterPanel(MainWindow mainWindow) {
        this.parent = mainWindow;
        this.setLayout(new BorderLayout());
        this.theTabbedPane = new JTabbedPane();
        this.theTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = FilterPanel.this.theTabbedPane.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                int n2 = FilterPanel.this.theTabbedPane.indexOfComponent(FilterPanel.this.tabContents);
                if (n2 >= 0) {
                    FilterPanel.this.theTabbedPane.setComponentAt(n2, new JPanel());
                }
                FilterPanel.this.theTabbedPane.setComponentAt(n, FilterPanel.this.tabContents);
                FilterPanel.this.currentFilterIndex = n;
                FilterPanel.this.filterNameField.setText(FilterPanel.this.theTabbedPane.getTitleAt(n));
                FilterPanel.this.filterMenu.setSelectedItem(FilterPanel.this.currentFilter());
                FilterPanel.this.refreshChannelList();
            }
        });
        this.tabContents = new JPanel();
        this.tabContents.setLayout(new BorderLayout());
        this.theTree = new JTree();
        this.theTree.setRootVisible(false);
        this.theTree.setCellRenderer(new MyTreeCellRenderer());
        this.theTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = FilterPanel.this.theTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n < 0) {
                    return;
                }
                TreePath treePath = FilterPanel.this.theTree.getPathForRow(n);
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof ChannelInfo)) {
                    return;
                }
                ChannelInfo channelInfo = (ChannelInfo)object;
                boolean bl = FilterPanel.this.currentFilter().isFiltered(channelInfo.getServiceID());
                FilterPanel.this.currentFilter().filterSid(channelInfo.getServiceID(), !bl);
                FilterPanel.this.parent.setFilter(FilterPanel.this.currentFilter().getFilterArray());
                FilterPanel.this.theTree.getModel().valueForPathChanged(treePath, channelInfo);
            }
        });
        this.tabContents.add((Component)new JScrollPane(this.theTree), "Center");
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Filter name:");
        jPanel.add(jLabel);
        this.filterNameField = new JTextField();
        this.filterNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doIt();
            }

            private void doIt() {
                FilterPanel.this.currentFilter().setName(FilterPanel.this.filterNameField.getText());
                FilterPanel.this.theTabbedPane.setTitleAt(FilterPanel.this.theTabbedPane.getSelectedIndex(), FilterPanel.this.filterNameField.getText());
                FilterPanel.this.filterMenu.repaint();
            }
        });
        this.filterNameField.setPreferredSize(new Dimension(150, (int)this.filterNameField.getPreferredSize().getHeight()));
        jPanel.add(this.filterNameField);
        JButton jButton = new JButton("+");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Filter filter = new Filter(FilterPanel.this.currentFilter());
                FilterPanel.this.filterSets.add(filter);
                FilterPanel.this.theTabbedPane.addTab(filter.getName(), new JPanel());
                FilterPanel.this.filterMenu.addItem(filter);
                FilterPanel.this.currentFilterIndex = FilterPanel.this.filterSets.size() - 1;
                FilterPanel.this.theTabbedPane.setSelectedIndex(FilterPanel.this.currentFilterIndex);
                FilterPanel.this.deleteButton.setEnabled(FilterPanel.this.filterSets.size() > 1);
                FilterPanel.this.filterMenu.setEnabled(FilterPanel.this.filterSets.size() > 1);
            }
        });
        jPanel.add(jButton);
        this.deleteButton = new JButton("-");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterPanel.this.ignoreFilterMenu = true;
                FilterPanel.this.filterMenu.removeItem(FilterPanel.this.currentFilter());
                FilterPanel.this.filterSets.remove(FilterPanel.this.currentFilterIndex);
                FilterPanel.this.theTabbedPane.remove(FilterPanel.this.currentFilterIndex);
                FilterPanel.this.currentFilterIndex = FilterPanel.this.theTabbedPane.getSelectedIndex();
                FilterPanel.this.filterMenu.setSelectedItem(FilterPanel.this.currentFilter());
                FilterPanel.this.ignoreFilterMenu = false;
                FilterPanel.this.theTabbedPane.setComponentAt(FilterPanel.this.currentFilterIndex, FilterPanel.this.tabContents);
                FilterPanel.this.deleteButton.setEnabled(FilterPanel.this.filterSets.size() > 1);
                FilterPanel.this.filterMenu.setEnabled(FilterPanel.this.filterSets.size() > 1);
            }
        });
        jPanel.add(this.deleteButton);
        this.tabContents.add((Component)jPanel, "South");
        this.add((Component)this.theTabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabel = new JLabel("Selected tab will be default startup filter.");
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.filterMenu = new JComboBox();
        this.filterMenu.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Filter) {
                    object = ((Filter)object).getName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.filterMenu.setEnabled(false);
        this.filterMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FilterPanel.this.ignoreFilterMenu) {
                    return;
                }
                Filter filter = (Filter)FilterPanel.this.filterMenu.getSelectedItem();
                FilterPanel.this.parent.setFilter(filter.getFilterArray());
                for (int i = 0; i < FilterPanel.this.filterSets.size(); ++i) {
                    if (filter != FilterPanel.this.filterSets.get(i)) continue;
                    FilterPanel.this.currentFilterIndex = i;
                    break;
                }
                FilterPanel.this.ignoreFilterMenu = true;
                if (FilterPanel.this.isVisible()) {
                    FilterPanel.this.theTabbedPane.setSelectedIndex(FilterPanel.this.currentFilterIndex);
                }
                FilterPanel.this.ignoreFilterMenu = false;
            }
        });
        this.reloadFilterSettings();
        this.setSize(new Dimension(450, 550));
    }

    private void refreshChannelList() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        ((DefaultTreeModel)this.theTree.getModel()).setRoot(defaultMutableTreeNode);
        HashMap<String, HashSet<ChannelInfo>> hashMap = new HashMap<String, HashSet<ChannelInfo>>();
        ChannelInfo[] channelInfoArray = this.parent.getChannelList();
        for (int i = 0; i < channelInfoArray.length; ++i) {
            HashSet<ChannelInfo> hashSet = (HashSet<ChannelInfo>)hashMap.get(channelInfoArray[i].getChannelGenre());
            if (hashSet == null) {
                hashSet = new HashSet<ChannelInfo>();
                hashMap.put(channelInfoArray[i].getChannelGenre(), hashSet);
            }
            hashSet.add(channelInfoArray[i]);
        }
        HashSet[] hashSetArray = new HashSet[hashMap.size()];
        int n = 0;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            hashSetArray[n++] = (HashSet)iterator.next();
        }
        Arrays.sort(hashSetArray, new Comparator(){

            public int compare(Object object, Object object2) {
                HashSet hashSet = (HashSet)object;
                HashSet hashSet2 = (HashSet)object2;
                int n = FilterPanel.lowestChannelInHashSet(hashSet);
                int n2 = FilterPanel.lowestChannelInHashSet(hashSet2);
                return new Integer(n).compareTo(new Integer(n2));
            }
        });
        for (n = 0; n < hashSetArray.length; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            HashSet hashSet = hashSetArray[n];
            ChannelInfo[] channelInfoArray2 = new ChannelInfo[hashSet.size()];
            iterator = hashSet.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                channelInfoArray2[n2++] = (ChannelInfo)iterator.next();
            }
            Arrays.sort(channelInfoArray2, new Comparator(){

                public int compare(Object object, Object object2) {
                    ChannelInfo channelInfo = (ChannelInfo)object;
                    ChannelInfo channelInfo2 = (ChannelInfo)object2;
                    return new Integer(channelInfo.getChannelNumber()).compareTo(new Integer(channelInfo2.getChannelNumber()));
                }
            });
            defaultMutableTreeNode2.setUserObject(channelInfoArray2[0].getChannelGenre());
            for (n2 = 0; n2 < channelInfoArray2.length; ++n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(channelInfoArray2[n2], false);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                this.theTree.expandPath(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode3}));
            }
        }
        ((DefaultTreeModel)this.theTree.getModel()).nodeStructureChanged(defaultMutableTreeNode);
        FilterPanel.expandAll(this.theTree);
    }

    private static void expandAll(JTree jTree) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        FilterPanel.expandNode(jTree, new TreePath(treeNode));
    }

    private static void expandNode(JTree jTree, TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
            FilterPanel.expandNode(jTree, treePath2);
        }
        jTree.expandPath(treePath);
    }

    private static int lowestChannelInHashSet(HashSet hashSet) {
        int n = Integer.MAX_VALUE;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ChannelInfo channelInfo = (ChannelInfo)iterator.next();
            if (n <= channelInfo.getChannelNumber()) continue;
            n = channelInfo.getChannelNumber();
        }
        return n;
    }

    public JComboBox getFilterMenu() {
        return this.filterMenu;
    }

    public void reload() {
        if (!RadioCommander.theRadio().isOn()) {
            return;
        }
        this.reloadFilterSettings();
    }

    public void save() {
        if (!RadioCommander.theRadio().isOn()) {
            return;
        }
        this.saveFilterSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reloadFilterSettings() {
        this.ignoreFilterMenu = true;
        try {
            Object object;
            Preferences preferences = JXM.myUserNode().node(FILTER_SET_ORDER);
            try {
                object = preferences.keys();
                Arrays.sort(object, new Comparator(){

                    public int compare(Object object, Object object2) {
                        try {
                            int n = Integer.parseInt((String)object);
                            int n2 = Integer.parseInt((String)object2);
                            return new Integer(n).compareTo(new Integer(n2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            return 0;
                        }
                    }
                });
                Preferences preferences2 = JXM.myUserNode().node(FILTER_SET_KEY);
                this.theTabbedPane.removeAll();
                this.filterMenu.removeAllItems();
                this.filterSets.clear();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string = preferences.get(object[i], null);
                    if (string == null) {
                        return;
                    }
                    Filter filter = new Filter();
                    filter.setName(string);
                    byte[] byArray = preferences2.getByteArray(string, new byte[0]);
                    for (int j = 0; j < byArray.length; ++j) {
                        filter.filterSid(byArray[j] & 0xFF, true);
                    }
                    this.filterSets.add(filter);
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            if (this.filterSets.isEmpty()) {
                object = new Filter();
                this.filterSets.add(object);
            }
            for (int i = 0; i < this.filterSets.size(); ++i) {
                this.theTabbedPane.add(((Filter)this.filterSets.get(i)).getName(), new JPanel());
                this.filterMenu.addItem(this.filterSets.get(i));
            }
            String string = JXM.myUserNode().get(DEFAULT_FILTER_KEY, "");
            this.currentFilterIndex = 0;
            for (int i = 0; i < this.filterSets.size(); ++i) {
                if (!string.equals(((Filter)this.filterSets.get(i)).getName())) continue;
                this.currentFilterIndex = i;
                break;
            }
            this.theTabbedPane.setSelectedIndex(this.currentFilterIndex);
            this.filterMenu.setSelectedItem(this.currentFilter());
            this.deleteButton.setEnabled(this.filterSets.size() > 1);
            this.filterMenu.setEnabled(RadioCommander.theRadio().isOn() && this.filterSets.size() > 1);
            this.parent.setFilter(this.currentFilter().getFilterArray());
            return;
        }
        finally {
            this.ignoreFilterMenu = false;
        }
    }

    private void saveFilterSettings() {
        JXM.myUserNode().put(DEFAULT_FILTER_KEY, this.currentFilter().getName());
        Preferences preferences = JXM.myUserNode().node(FILTER_SET_KEY);
        try {
            Filter filter;
            int n;
            preferences.clear();
            for (n = 0; n < this.filterSets.size(); ++n) {
                filter = (Filter)this.filterSets.get(n);
                preferences.putByteArray(filter.getName(), filter.getFilterArray());
            }
            preferences = JXM.myUserNode().node(FILTER_SET_ORDER);
            preferences.clear();
            for (n = 0; n < this.filterSets.size(); ++n) {
                filter = (Filter)this.filterSets.get(n);
                preferences.put(Integer.toString(n), filter.getName());
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.parent.setFilter(this.currentFilter().getFilterArray());
    }

    class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (defaultMutableTreeNode.isLeaf()) {
                ChannelInfo channelInfo = (ChannelInfo)defaultMutableTreeNode.getUserObject();
                if (channelInfo == null) {
                    return super.getTreeCellRendererComponent(jTree, object, false, bl2, bl3, n, false);
                }
                JCheckBox jCheckBox = new JCheckBox(channelInfo.getChannelName());
                jCheckBox.setSelected(!FilterPanel.this.currentFilter().isFiltered(channelInfo.getServiceID()));
                jCheckBox.setOpaque(false);
                return jCheckBox;
            }
            return super.getTreeCellRendererComponent(jTree, object, false, bl2, bl3, n, false);
        }
    }

    private class Filter {
        private HashSet filterList;
        private String name;

        public boolean isFiltered(int n) {
            return this.filterList.contains(new Integer(n));
        }

        public Filter() {
            this.filterList = new HashSet();
            this.name = "Default";
        }

        public Filter(Filter filter) {
            this.filterList = new HashSet(filter.filterList);
            this.name = "copy of " + filter.getName();
        }

        public void filterSid(int n, boolean bl) {
            Integer n2 = new Integer(n);
            if (bl) {
                this.filterList.add(n2);
            } else {
                this.filterList.remove(n2);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public byte[] getFilterArray() {
            byte[] byArray = new byte[this.filterList.size()];
            Iterator iterator = this.filterList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                byArray[n++] = ((Integer)iterator.next()).byteValue();
            }
            return byArray;
        }
    }
}

