/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.index.sweepline.SweepLineIndex;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class SweeplineNestedRingTester {
    private final CGAlgorithms cga = new CGAlgorithms();
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Envelope totalEnv = new Envelope();
    private SweepLineIndex sweepLine;
    private Coordinate nestedPt = null;

    public SweeplineNestedRingTester(GeometryGraph geometryGraph) {
        this.graph = geometryGraph;
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public void add(LinearRing linearRing) {
        this.rings.add(linearRing);
    }

    public boolean isNonNested() {
        this.buildIndex();
        OverlapAction overlapAction = new OverlapAction();
        this.sweepLine.computeOverlaps(overlapAction);
        return overlapAction.isNonNested;
    }

    private void buildIndex() {
        this.sweepLine = new SweepLineIndex();
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing linearRing = (LinearRing)this.rings.get(i);
            Envelope envelope = linearRing.getEnvelopeInternal();
            SweepLineInterval sweepLineInterval = new SweepLineInterval(envelope.getMinX(), envelope.getMaxX(), linearRing);
            this.sweepLine.add(sweepLineInterval);
        }
    }

    private boolean isInside(LinearRing linearRing, LinearRing linearRing2) {
        Coordinate[] coordinateArray = linearRing.getCoordinates();
        Coordinate[] coordinateArray2 = linearRing2.getCoordinates();
        if (!linearRing.getEnvelopeInternal().intersects(linearRing2.getEnvelopeInternal())) {
            return false;
        }
        Coordinate coordinate = IsValidOp.findPtNotNode(coordinateArray, linearRing2, this.graph);
        Assert.isTrue(coordinate != null, "Unable to find a ring point not a node of the search ring");
        boolean bl = CGAlgorithms.isPointInRing(coordinate, coordinateArray2);
        if (bl) {
            this.nestedPt = coordinate;
            return true;
        }
        return false;
    }

    class OverlapAction
    implements SweepLineOverlapAction {
        boolean isNonNested = true;

        OverlapAction() {
        }

        public void overlap(SweepLineInterval sweepLineInterval, SweepLineInterval sweepLineInterval2) {
            LinearRing linearRing;
            LinearRing linearRing2 = (LinearRing)sweepLineInterval.getItem();
            if (linearRing2 == (linearRing = (LinearRing)sweepLineInterval2.getItem())) {
                return;
            }
            if (SweeplineNestedRingTester.this.isInside(linearRing2, linearRing)) {
                this.isNonNested = false;
            }
        }
    }
}

