/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.MaximalEdgeRing;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ConnectedInteriorTester {
    private GeometryFactory geometryFactory = new GeometryFactory();
    private CGAlgorithms cga = new CGAlgorithms();
    private GeometryGraph geomGraph;
    private Coordinate disconnectedRingcoord;

    public static Coordinate findDifferentPoint(Coordinate[] coordinateArray, Coordinate coordinate) {
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (coordinateArray[i].equals(coordinate)) continue;
            return coordinateArray[i];
        }
        return null;
    }

    public ConnectedInteriorTester(GeometryGraph geometryGraph) {
        this.geomGraph = geometryGraph;
    }

    public Coordinate getCoordinate() {
        return this.disconnectedRingcoord;
    }

    public boolean isInteriorsConnected() {
        ArrayList arrayList = new ArrayList();
        this.geomGraph.computeSplitEdges(arrayList);
        PlanarGraph planarGraph = new PlanarGraph(new OverlayNodeFactory());
        planarGraph.addEdges(arrayList);
        this.setAllEdgesInResult(planarGraph);
        planarGraph.linkAllDirectedEdges();
        List list = this.buildEdgeRings(planarGraph.getEdgeEnds());
        this.visitShellInteriors(this.geomGraph.getGeometry(), planarGraph);
        return !this.hasUnvisitedShellEdge(list);
    }

    private void setAllEdgesInResult(PlanarGraph planarGraph) {
        Iterator iterator = planarGraph.getEdgeEnds().iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            directedEdge.setInResult(true);
        }
    }

    private List buildEdgeRings(Collection collection) {
        ArrayList<MaximalEdgeRing> arrayList = new ArrayList<MaximalEdgeRing>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (directedEdge.getEdgeRing() != null) continue;
            MaximalEdgeRing maximalEdgeRing = new MaximalEdgeRing(directedEdge, this.geometryFactory, this.cga);
            arrayList.add(maximalEdgeRing);
        }
        return arrayList;
    }

    private void visitShellInteriors(Geometry geometry, PlanarGraph planarGraph) {
        Geometry geometry2;
        if (geometry instanceof Polygon) {
            geometry2 = (Polygon)geometry;
            this.visitInteriorRing(((Polygon)geometry2).getExteriorRing(), planarGraph);
        }
        if (geometry instanceof MultiPolygon) {
            geometry2 = (MultiPolygon)geometry;
            for (int i = 0; i < ((GeometryCollection)geometry2).getNumGeometries(); ++i) {
                Polygon polygon = (Polygon)((GeometryCollection)geometry2).getGeometryN(i);
                this.visitInteriorRing(polygon.getExteriorRing(), planarGraph);
            }
        }
    }

    private void visitInteriorRing(LineString lineString, PlanarGraph planarGraph) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate coordinate = coordinateArray[0];
        Coordinate coordinate2 = ConnectedInteriorTester.findDifferentPoint(coordinateArray, coordinate);
        Edge edge = planarGraph.findEdgeInSameDirection(coordinate, coordinate2);
        DirectedEdge directedEdge = (DirectedEdge)planarGraph.findEdgeEnd(edge);
        DirectedEdge directedEdge2 = null;
        if (directedEdge.getLabel().getLocation(0, 2) == 0) {
            directedEdge2 = directedEdge;
        } else if (directedEdge.getSym().getLabel().getLocation(0, 2) == 0) {
            directedEdge2 = directedEdge.getSym();
        }
        Assert.isTrue(directedEdge2 != null, "unable to find dirEdge with Interior on RHS");
        this.visitLinkedDirectedEdges(directedEdge2);
    }

    protected void visitLinkedDirectedEdges(DirectedEdge directedEdge) {
        DirectedEdge directedEdge2 = directedEdge;
        DirectedEdge directedEdge3 = directedEdge;
        do {
            Assert.isTrue(directedEdge3 != null, "found null Directed Edge");
            directedEdge3.setVisited(true);
        } while ((directedEdge3 = directedEdge3.getNext()) != directedEdge2);
    }

    private boolean hasUnvisitedShellEdge(List list) {
        for (int i = 0; i < list.size(); ++i) {
            List list2;
            DirectedEdge directedEdge;
            EdgeRing edgeRing = (EdgeRing)list.get(i);
            if (edgeRing.isHole() || (directedEdge = (DirectedEdge)(list2 = edgeRing.getEdges()).get(0)).getLabel().getLocation(0, 2) != 0) continue;
            for (int j = 0; j < list2.size(); ++j) {
                directedEdge = (DirectedEdge)list2.get(j);
                if (directedEdge.isVisited()) continue;
                this.disconnectedRingcoord = directedEdge.getCoordinate();
                return true;
            }
        }
        return false;
    }
}

