/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.linemerge;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.linemerge.EdgeString;
import com.vividsolutions.jts.operation.linemerge.LineMergeDirectedEdge;
import com.vividsolutions.jts.operation.linemerge.LineMergeGraph;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class LineMerger {
    private LineMergeGraph graph = new LineMergeGraph();
    private Collection mergedLineStrings = null;
    private GeometryFactory factory = null;
    private Collection edgeStrings = null;

    public void add(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Geometry geometry = (Geometry)iterator.next();
            this.add(geometry);
        }
    }

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geometry) {
                if (geometry instanceof LineString) {
                    LineMerger.this.add((LineString)geometry);
                }
            }
        });
    }

    private void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
    }

    private void merge() {
        if (this.mergedLineStrings != null) {
            return;
        }
        this.edgeStrings = new ArrayList();
        this.buildEdgeStringsForObviousStartNodes();
        this.buildEdgeStringsForIsolatedLoops();
        this.mergedLineStrings = new ArrayList();
        Iterator iterator = this.edgeStrings.iterator();
        while (iterator.hasNext()) {
            EdgeString edgeString = (EdgeString)iterator.next();
            this.mergedLineStrings.add(edgeString.toLineString());
        }
    }

    private void buildEdgeStringsForObviousStartNodes() {
        this.buildEdgeStringsForNonDegree2Nodes();
    }

    private void buildEdgeStringsForIsolatedLoops() {
        this.buildEdgeStringsForUnprocessedNodes();
    }

    private void buildEdgeStringsForUnprocessedNodes() {
        Iterator iterator = this.graph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.isMarked()) continue;
            Assert.isTrue(node.getDegree() == 2);
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private void buildEdgeStringsForNonDegree2Nodes() {
        Iterator iterator = this.graph.getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getDegree() == 2) continue;
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private void buildEdgeStringsStartingAt(Node node) {
        Iterator iterator = node.getOutEdges().iterator();
        while (iterator.hasNext()) {
            LineMergeDirectedEdge lineMergeDirectedEdge = (LineMergeDirectedEdge)iterator.next();
            if (lineMergeDirectedEdge.getEdge().isMarked()) continue;
            this.edgeStrings.add(this.buildEdgeStringStartingWith(lineMergeDirectedEdge));
        }
    }

    private EdgeString buildEdgeStringStartingWith(LineMergeDirectedEdge lineMergeDirectedEdge) {
        EdgeString edgeString = new EdgeString(this.factory);
        LineMergeDirectedEdge lineMergeDirectedEdge2 = lineMergeDirectedEdge;
        do {
            edgeString.add(lineMergeDirectedEdge2);
            lineMergeDirectedEdge2.getEdge().setMarked(true);
        } while ((lineMergeDirectedEdge2 = lineMergeDirectedEdge2.getNext()) != null && lineMergeDirectedEdge2 != lineMergeDirectedEdge);
        return edgeString;
    }

    public Collection getMergedLineStrings() {
        this.merge();
        return this.mergedLineStrings;
    }
}

