/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.sweepline;

import com.vividsolutions.jts.index.sweepline.SweepLineEvent;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SweepLineIndex {
    List events = new ArrayList();
    private boolean indexBuilt;
    private int nOverlaps;

    public void add(SweepLineInterval sweepLineInterval) {
        SweepLineEvent sweepLineEvent = new SweepLineEvent(sweepLineInterval.getMin(), null, sweepLineInterval);
        this.events.add(sweepLineEvent);
        this.events.add(new SweepLineEvent(sweepLineInterval.getMax(), sweepLineEvent, sweepLineInterval));
    }

    private void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        Collections.sort(this.events);
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent.isDelete()) continue;
            sweepLineEvent.getInsertEvent().setDeleteEventIndex(i);
        }
        this.indexBuilt = true;
    }

    public void computeOverlaps(SweepLineOverlapAction sweepLineOverlapAction) {
        this.nOverlaps = 0;
        this.buildIndex();
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent.isInsert()) continue;
            this.processOverlaps(i, sweepLineEvent.getDeleteEventIndex(), sweepLineEvent.getInterval(), sweepLineOverlapAction);
        }
    }

    private void processOverlaps(int n, int n2, SweepLineInterval sweepLineInterval, SweepLineOverlapAction sweepLineOverlapAction) {
        for (int i = n; i < n2; ++i) {
            SweepLineEvent sweepLineEvent = (SweepLineEvent)this.events.get(i);
            if (!sweepLineEvent.isInsert()) continue;
            SweepLineInterval sweepLineInterval2 = sweepLineEvent.getInterval();
            sweepLineOverlapAction.overlap(sweepLineInterval, sweepLineInterval2);
            ++this.nOverlaps;
        }
    }
}

