/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.quadtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.quadtree.Key;
import com.vividsolutions.jts.index.quadtree.NodeBase;
import com.vividsolutions.jts.util.Assert;

public class Node
extends NodeBase {
    private Envelope env;
    private Coordinate centre;
    private int level;

    public static Node createNode(Envelope envelope) {
        Key key = new Key(envelope);
        Node node = new Node(key.getEnvelope(), key.getLevel());
        return node;
    }

    public static Node createExpanded(Node node, Envelope envelope) {
        Envelope envelope2 = new Envelope(envelope);
        if (node != null) {
            envelope2.expandToInclude(node.env);
        }
        Node node2 = Node.createNode(envelope2);
        if (node != null) {
            node2.insertNode(node);
        }
        return node2;
    }

    public Node(Envelope envelope, int n) {
        this.env = envelope;
        this.level = n;
        this.centre = new Coordinate();
        this.centre.x = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        this.centre.y = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    protected boolean isSearchMatch(Envelope envelope) {
        return this.env.intersects(envelope);
    }

    public Node getNode(Envelope envelope) {
        int n = Node.getSubnodeIndex(envelope, this.centre);
        if (n != -1) {
            Node node = this.getSubnode(n);
            return node.getNode(envelope);
        }
        return this;
    }

    public NodeBase find(Envelope envelope) {
        int n = Node.getSubnodeIndex(envelope, this.centre);
        if (n == -1) {
            return this;
        }
        if (this.subnode[n] != null) {
            Node node = this.subnode[n];
            return node.find(envelope);
        }
        return this;
    }

    void insertNode(Node node) {
        Assert.isTrue(this.env == null || this.env.contains(node.env));
        int n = Node.getSubnodeIndex(node.env, this.centre);
        if (node.level == this.level - 1) {
            this.subnode[n] = node;
        } else {
            Node node2 = this.createSubnode(n);
            node2.insertNode(node);
            this.subnode[n] = node2;
        }
    }

    private Node getSubnode(int n) {
        if (this.subnode[n] == null) {
            this.subnode[n] = this.createSubnode(n);
        }
        return this.subnode[n];
    }

    private Node createSubnode(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (n) {
            case 0: {
                d = this.env.getMinX();
                d2 = this.centre.x;
                d3 = this.env.getMinY();
                d4 = this.centre.y;
                break;
            }
            case 1: {
                d = this.centre.x;
                d2 = this.env.getMaxX();
                d3 = this.env.getMinY();
                d4 = this.centre.y;
                break;
            }
            case 2: {
                d = this.env.getMinX();
                d2 = this.centre.x;
                d3 = this.centre.y;
                d4 = this.env.getMaxY();
                break;
            }
            case 3: {
                d = this.centre.x;
                d2 = this.env.getMaxX();
                d3 = this.centre.y;
                d4 = this.env.getMaxY();
            }
        }
        Envelope envelope = new Envelope(d, d2, d3, d4);
        Node node = new Node(envelope, this.level - 1);
        return node;
    }
}

