/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;

public class SweepLineSegment {
    Edge edge;
    Coordinate[] pts;
    int ptIndex;

    public SweepLineSegment(Edge edge, int n) {
        this.edge = edge;
        this.ptIndex = n;
        this.pts = edge.getCoordinates();
    }

    public double getMinX() {
        double d = this.pts[this.ptIndex].x;
        double d2 = this.pts[this.ptIndex + 1].x;
        return d < d2 ? d : d2;
    }

    public double getMaxX() {
        double d = this.pts[this.ptIndex].x;
        double d2 = this.pts[this.ptIndex + 1].x;
        return d > d2 ? d : d2;
    }

    public void computeIntersections(SweepLineSegment sweepLineSegment, SegmentIntersector segmentIntersector) {
        segmentIntersector.addIntersections(this.edge, this.ptIndex, sweepLineSegment.edge, sweepLineSegment.ptIndex);
    }
}

