/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;

class DefaultCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private Coordinate[] coordinates;

    public DefaultCoordinateSequence(Coordinate[] coordinateArray) {
        if (Geometry.hasNullElements(coordinateArray)) {
            throw new IllegalArgumentException("Null coordinate");
        }
        this.coordinates = coordinateArray;
    }

    public Coordinate getCoordinate(int n) {
        return this.coordinates[n];
    }

    public Object clone() {
        Coordinate[] coordinateArray = new Coordinate[this.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            coordinateArray[i] = (Coordinate)this.coordinates[i].clone();
        }
        return new DefaultCoordinateSequence(coordinateArray);
    }

    public int size() {
        return this.coordinates.length;
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.coordinates[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

