/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.task;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Date;
import javax.swing.Timer;

public class TaskMonitorManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ThreadedPlugIn plugIn, PlugInContext context) {
        TaskMonitorDialog progressDialog = new TaskMonitorDialog((Frame)context.getWorkbenchFrame(), context.getErrorHandler());
        progressDialog.setTitle(plugIn.getName());
        final TaskWrapper taskWrapper = new TaskWrapper(plugIn, context, progressDialog);
        progressDialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                new Thread(taskWrapper).start();
            }
        });
        GUIUtil.centreOnWindow(progressDialog);
        Timer timer = this.timer(new Date(), plugIn, context.getWorkbenchFrame());
        timer.start();
        try {
            progressDialog.setVisible(true);
        }
        finally {
            timer.stop();
        }
    }

    private Timer timer(final Date start, final ThreadedPlugIn plugIn, final WorkbenchFrame workbenchFrame) {
        return new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String message = "";
                message = message + StringUtil.toTimeString(new Date().getTime() - start.getTime());
                message = message + " (" + plugIn.getName() + ")";
                workbenchFrame.setTimeMessage(message);
            }
        });
    }

    private class TaskWrapper
    implements Runnable {
        private ThreadedPlugIn plugIn;
        private PlugInContext context;
        private TaskMonitorDialog dialog;

        public TaskWrapper(ThreadedPlugIn plugIn, PlugInContext context, TaskMonitorDialog dialog) {
            this.plugIn = plugIn;
            this.context = context;
            this.dialog = dialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Throwable throwable = null;
            try {
                try {
                    this.plugIn.run(this.dialog, this.context);
                }
                catch (Throwable t) {
                    throwable = t;
                    Object var4_3 = null;
                    this.dialog.setVisible(false);
                    if (throwable != null) {
                        this.context.getErrorHandler().handleThrowable(throwable);
                    }
                    this.context = null;
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable2) {
                Object var4_4 = null;
                this.dialog.setVisible(false);
                if (throwable != null) {
                    this.context.getErrorHandler().handleThrowable(throwable);
                }
                this.context = null;
                throw throwable2;
            }
            this.dialog.setVisible(false);
            if (throwable != null) {
                this.context.getErrorHandler().handleThrowable(throwable);
            }
            this.context = null;
        }
    }
}

