/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStylePanel;
import com.vividsolutions.jump.workbench.ui.style.DecorationStylePanel;
import com.vividsolutions.jump.workbench.ui.style.LabelStylePanel;
import com.vividsolutions.jump.workbench.ui.style.RenderingStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ChangeStylesPlugIn
extends AbstractPlugIn {
    private static final String LAST_TAB_KEY = (class$com$vividsolutions$jump$workbench$ui$style$ChangeStylesPlugIn == null ? (class$com$vividsolutions$jump$workbench$ui$style$ChangeStylesPlugIn = ChangeStylesPlugIn.class$("com.vividsolutions.jump.workbench.ui.style.ChangeStylesPlugIn")) : class$com$vividsolutions$jump$workbench$ui$style$ChangeStylesPlugIn).getName() + " - LAST TAB";
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$style$ChangeStylesPlugIn;

    public boolean execute(PlugInContext context) throws Exception {
        final Layer layer = context.getSelectedLayer(0);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), "Change Styles", true);
        dialog.setInset(0);
        dialog.setSideBarImage(IconLoader.icon("Symbology.gif"));
        dialog.setSideBarDescription("You can use this dialog to change the colour, line width, and other visual properties of a layer.");
        final ArrayList<JPanel> stylePanels = new ArrayList<JPanel>();
        RenderingStylePanel renderingStylePanel = new RenderingStylePanel(context.getWorkbenchContext().getWorkbench().getBlackboard(), layer);
        stylePanels.add(renderingStylePanel);
        DecorationStylePanel decorationStylePanel = new DecorationStylePanel(layer, context.getWorkbenchFrame().getChoosableStyleClasses());
        decorationStylePanel.setPreferredSize(new Dimension(400, 300));
        if (layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount() > 1) {
            ColorThemingStylePanel colorThemingStylePanel = new ColorThemingStylePanel(layer, context.getWorkbenchContext());
            colorThemingStylePanel.setPreferredSize(new Dimension(400, 300));
            stylePanels.add(colorThemingStylePanel);
            GUIUtil.sync(renderingStylePanel.getTransparencySlider(), colorThemingStylePanel.getTransparencySlider());
            GUIUtil.sync(renderingStylePanel.getSynchronizeCheckBox(), colorThemingStylePanel.getSynchronizeCheckBox());
        } else {
            stylePanels.add(new DummyColorThemingStylePanel());
        }
        stylePanels.add(new LabelStylePanel(layer, context.getLayerViewPanel(), dialog, context.getErrorHandler()));
        stylePanels.add(decorationStylePanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        Iterator i = stylePanels.iterator();
        while (i.hasNext()) {
            final StylePanel stylePanel = (StylePanel)i.next();
            tabbedPane.add((Component)((Object)stylePanel), stylePanel.getTitle());
            dialog.addEnableChecks(stylePanel.getTitle(), Arrays.asList(new EnableCheck(){

                public String check(JComponent component) {
                    return stylePanel.validateInput();
                }
            }));
        }
        dialog.addRow(tabbedPane);
        tabbedPane.setSelectedComponent(this.find(stylePanels, (String)context.getWorkbenchContext().getWorkbench().getBlackboard().get(LAST_TAB_KEY, ((StylePanel)stylePanels.iterator().next()).getTitle())));
        dialog.setVisible(true);
        context.getWorkbenchContext().getWorkbench().getBlackboard().put(LAST_TAB_KEY, ((StylePanel)((Object)tabbedPane.getSelectedComponent())).getTitle());
        if (dialog.wasOKPressed()) {
            final Collection oldStyles = layer.cloneStyles();
            layer.getLayerManager().deferFiringEvents(new Runnable(){

                public void run() {
                    Iterator i = stylePanels.iterator();
                    while (i.hasNext()) {
                        StylePanel stylePanel = (StylePanel)i.next();
                        stylePanel.updateStyles();
                    }
                }
            });
            final Collection newStyles = layer.cloneStyles();
            this.execute(new UndoableCommand(this.getName()){

                public void execute() {
                    layer.setStyles(newStyles);
                }

                public void unexecute() {
                    layer.setStyles(oldStyles);
                }
            }, context);
            boolean firingEvents = layer.getLayerManager().isFiringEvents();
            layer.getLayerManager().setFiringEvents(false);
            layer.getLayerManager().setFiringEvents(firingEvents);
            layer.fireAppearanceChanged();
            return true;
        }
        return false;
    }

    private Component find(Collection stylePanels, String title) {
        Iterator i = stylePanels.iterator();
        while (i.hasNext()) {
            StylePanel stylePanel = (StylePanel)i.next();
            if (!stylePanel.getTitle().equals(title)) continue;
            return (Component)((Object)stylePanel);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Palette.gif");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DummyColorThemingStylePanel
    extends JPanel
    implements StylePanel {
        public DummyColorThemingStylePanel() {
            super(new GridBagLayout());
            this.add(new JLabel("This layer has no attributes."));
        }

        public String getTitle() {
            return "Colour Theming";
        }

        public void updateStyles() {
        }

        public String validateInput() {
            return null;
        }
    }
}

