/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicFillPattern;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.FillPatternFactory;
import com.vividsolutions.jump.workbench.ui.style.AbstractPalettePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.ListPalettePanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class BasicStylePanel
extends JPanel {
    protected static final int SLIDER_TEXT_FIELD_COLUMNS = 3;
    protected static final Dimension SLIDER_DIMENSION = new Dimension(130, 49);
    private Paint[] fillPatterns = new FillPatternFactory().createFillPatterns();
    protected JPanel centerPanel = new JPanel();
    private AbstractPalettePanel palettePanel;
    protected JCheckBox fillCheckBox = new JCheckBox();
    protected JCheckBox lineCheckBox = new JCheckBox();
    protected TransparencyPanel transparencyPanel = new TransparencyPanel();
    protected JLabel transparencyLabel = new JLabel();
    protected ColorChooserPanel lineColorChooserPanel = new ColorChooserPanel();
    protected ColorChooserPanel fillColorChooserPanel = new ColorChooserPanel();
    protected JLabel lineWidthLabel = new JLabel();
    protected JCheckBox synchronizeCheckBox = new JCheckBox();
    private JCheckBox linePatternCheckBox = new JCheckBox();
    private JCheckBox fillPatternCheckBox = new JCheckBox();
    private String[] linePatterns = new String[]{"1", "3", "5", "5,1", "7", "7,12", "9", "9,2", "15,6", "20,3"};
    private JComboBox linePatternComboBox = new JComboBox(this.linePatterns){
        {
            ValidatingTextField.Cleaner cleaner = new ValidatingTextField.Cleaner(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public String clean(String text) {
                    String pattern = "";
                    StringTokenizer tokenizer = new StringTokenizer(StringUtil.replaceAll(text, ",", " "));
                    while (tokenizer.hasMoreTokens()) {
                        pattern = pattern + tokenizer.nextToken() + " ";
                    }
                    return StringUtil.replaceAll(pattern.trim(), " ", ",");
                }
            };
            BasicComboBoxEditor editor = new BasicComboBoxEditor();
            this.setEditor(editor);
            this.setEditable(true);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    1.access$000(this.this$1).updateControls();
                }
            });
            ValidatingTextField.installValidationBehavior((JTextField)editor.getEditorComponent(), new ValidatingTextField.Validator(this, cleaner){
                private final /* synthetic */ ValidatingTextField.Cleaner val$cleaner;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$cleaner = val$cleaner;
                }

                public boolean isValid(String text) {
                    try {
                        BasicStyle.toArray(this.val$cleaner.clean(text), 1.0f);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }, cleaner);
            ((JTextField)editor.getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void changedUpdate(DocumentEvent e) {
                    1.access$000(this.this$1).updateControls();
                }

                public void insertUpdate(DocumentEvent e) {
                    1.access$000(this.this$1).updateControls();
                }

                public void removeUpdate(DocumentEvent e) {
                    1.access$000(this.this$1).updateControls();
                }
            });
            this.setRenderer(new ListCellRenderer(this){
                private JPanel panel;
                private String linePattern;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.panel = new JPanel(this){
                        private int lineWidth;
                        private final /* synthetic */ 6 this$2;
                        {
                            this.this$2 = this$2;
                            this.lineWidth = 2;
                        }

                        protected void paintComponent(Graphics g) {
                            super.paintComponent(g);
                            Graphics2D g2 = (Graphics2D)g;
                            g2.setStroke(new BasicStroke(this.lineWidth, 0, 2, 1.0f, BasicStyle.toArray(6.access$100(this.this$2), this.lineWidth), 0.0f));
                            g2.draw(new Line2D.Double(0.0, (double)6.access$200(this.this$2).getHeight() / 2.0, 6.access$200(this.this$2).getWidth(), (double)6.access$200(this.this$2).getHeight() / 2.0));
                        }
                    };
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.linePattern = (String)value;
                    this.panel.setForeground(UIManager.getColor(isSelected ? "ComboBox.selectionForeground" : "ComboBox.foreground"));
                    this.panel.setBackground(UIManager.getColor(isSelected ? "ComboBox.selectionBackground" : "ComboBox.background"));
                    return this.panel;
                }

                static /* synthetic */ String access$100(6 x0) {
                    return x0.linePattern;
                }

                static /* synthetic */ JPanel access$200(6 x0) {
                    return x0.panel;
                }
            });
        }

        static /* synthetic */ BasicStylePanel access$000(1 x0) {
            return x0.BasicStylePanel.this;
        }
    };
    private JComboBox fillPatternComboBox = new JComboBox(this.fillPatterns){
        {
            this.setMaximumRowCount(24);
            this.setEditable(false);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ 8 this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    8.access$300(this.this$1).updateControls();
                }
            });
            this.setRenderer(new ListCellRenderer(this){
                private Paint fillPattern;
                private JLabel label;
                private JPanel panel;
                private final /* synthetic */ 8 this$1;
                {
                    this.this$1 = this$1;
                    this.label = new JLabel(" ");
                    this.panel = new JPanel(this, new BorderLayout()){
                        private final /* synthetic */ 10 this$2;
                        {
                            super(x0);
                            this.this$2 = this$2;
                            10.access$400(this.this$2).setPreferredSize(new Dimension(150, (int)10.access$400(this.this$2).getPreferredSize().getHeight()));
                            this.add((Component)10.access$400(this.this$2), "Center");
                        }

                        protected void paintComponent(Graphics g) {
                            super.paintComponent(g);
                            ((Graphics2D)g).setPaint(10.access$500(this.this$2));
                            ((Graphics2D)g).fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
                        }
                    };
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.fillPattern = (Paint)value;
                    this.label.setText("" + (1 + CollectionUtil.indexOf(this.fillPattern, BasicStylePanel.access$600(8.access$300(this.this$1)))));
                    this.label.setForeground(UIManager.getColor(isSelected ? "ComboBox.selectionForeground" : "ComboBox.foreground"));
                    this.panel.setBackground(UIManager.getColor(isSelected ? "ComboBox.selectionBackground" : "ComboBox.background"));
                    return this.panel;
                }

                static /* synthetic */ JLabel access$400(10 x0) {
                    return x0.label;
                }

                static /* synthetic */ Paint access$500(10 x0) {
                    return x0.fillPattern;
                }
            });
        }

        static /* synthetic */ BasicStylePanel access$300(8 x0) {
            return x0.BasicStylePanel.this;
        }
    };
    protected JSlider lineWidthSlider = new JSlider(){
        {
            this.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ 12 this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    12.access$700(this.this$1).updateControls();
                }
            });
        }

        static /* synthetic */ BasicStylePanel access$700(12 x0) {
            return x0.BasicStylePanel.this;
        }
    };
    private Blackboard blackboard;

    public BasicStylePanel() {
        this(null, 22);
    }

    public BasicStylePanel(Blackboard blackboard, int palettePanelVerticalScrollBarPolicy) {
        this.blackboard = blackboard;
        this.palettePanel = new ListPalettePanel(palettePanelVerticalScrollBarPolicy);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Assert.shouldNeverReachHere();
        }
        this.transparencyPanel.getSlider().getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BasicStylePanel.this.updateControls();
            }
        });
        this.palettePanel.add(new AbstractPalettePanel.Listener(){

            public void basicStyleChosen(BasicStyle basicStyle) {
                BasicStyle newBasicStyle = BasicStylePanel.this.getBasicStyle();
                newBasicStyle.setFillColor(basicStyle.getFillColor());
                newBasicStyle.setLineColor(basicStyle.getLineColor());
                newBasicStyle.setLineWidth(basicStyle.getLineWidth());
                newBasicStyle.setRenderingFill(basicStyle.isRenderingFill());
                newBasicStyle.setRenderingLine(basicStyle.isRenderingLine());
                BasicStylePanel.this.setBasicStyle(newBasicStyle);
            }
        });
        this.updateControls();
    }

    private String clean(String linePattern) {
        String pattern = "";
        StringTokenizer tokenizer = new StringTokenizer(StringUtil.replaceAll(linePattern, ",", " "));
        while (tokenizer.hasMoreTokens()) {
            pattern = pattern + tokenizer.nextToken() + " ";
        }
        return StringUtil.replaceAll(pattern.trim(), " ", ",");
    }

    void jbInit() throws Exception {
        this.lineWidthSlider.setPreferredSize(SLIDER_DIMENSION);
        this.lineWidthSlider.setPaintLabels(true);
        this.lineWidthSlider.setValue(1);
        this.lineWidthSlider.setLabelTable(this.lineWidthSlider.createStandardLabels(10));
        this.lineWidthSlider.setMajorTickSpacing(5);
        this.lineWidthSlider.setMaximum(30);
        this.lineWidthSlider.setMinorTickSpacing(1);
        this.setLayout(new GridBagLayout());
        this.linePatternCheckBox.setText("Line pattern:");
        this.fillPatternCheckBox.setText("Fill pattern:");
        this.linePatternCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.linePatternCheckBox_actionPerformed(e);
            }
        });
        this.fillPatternCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.fillPatternCheckBox_actionPerformed(e);
            }
        });
        this.add((Component)this.centerPanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JLabel("Presets"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.add((Component)this.palettePanel, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 30, 0, 0), 0, 0));
        this.centerPanel.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fillColorChooserPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.fillColorChooserPanel_actionPerformed(e);
            }
        });
        this.lineColorChooserPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.lineColorChooserPanel_actionPerformed(e);
            }
        });
        this.synchronizeCheckBox.setText("Sync line colour with fill colour");
        this.synchronizeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.synchronizeCheckBox_actionPerformed(e);
            }
        });
        this.fillCheckBox.setText("Fill:");
        this.fillCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.fillCheckBox_actionPerformed(e);
            }
        });
        this.lineCheckBox.setText("Line:");
        this.lineCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.lineCheckBox_actionPerformed(e);
            }
        });
        this.centerPanel.add((Component)GUIUtil.createSyncdTextField(this.transparencyPanel.getSlider(), 3), new GridBagConstraints(2, 21, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.lineWidthSlider, new GridBagConstraints(1, 19, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)GUIUtil.createSyncdTextField(this.lineWidthSlider, 3), new GridBagConstraints(2, 18, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.fillColorChooserPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicStylePanel.this.fillColorChooserPanel_actionPerformed(e);
            }
        });
        this.lineWidthLabel.setText("Line width:");
        this.transparencyLabel.setText("Transparency:");
        this.centerPanel.add((Component)this.synchronizeCheckBox, new GridBagConstraints(0, 18, 3, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.transparencyLabel, new GridBagConstraints(0, 21, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.fillColorChooserPanel, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.lineColorChooserPanel, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.transparencyPanel, new GridBagConstraints(1, 21, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.fillCheckBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.lineCheckBox, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.lineWidthLabel, new GridBagConstraints(0, 19, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.linePatternCheckBox, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.fillPatternCheckBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.linePatternComboBox, new GridBagConstraints(1, 16, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.centerPanel.add((Component)this.fillPatternComboBox, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 2), 0, 0));
    }

    public JSlider getTransparencySlider() {
        return this.transparencyPanel.getSlider();
    }

    protected void setAlpha(int alpha) {
        this.transparencyPanel.getSlider().setValue(255 - alpha);
    }

    protected int getAlpha() {
        return 255 - this.transparencyPanel.getSlider().getValue();
    }

    public void setBasicStyle(BasicStyle basicStyle) {
        this.addCustomFillPatterns();
        this.fillColorChooserPanel.setColor(basicStyle.getFillColor());
        this.lineColorChooserPanel.setColor(basicStyle.getLineColor());
        this.setAlpha(basicStyle.getAlpha());
        this.fillCheckBox.setSelected(basicStyle.isRenderingFill());
        this.lineCheckBox.setSelected(basicStyle.isRenderingLine());
        this.lineWidthSlider.setValue(basicStyle.getLineWidth());
        this.linePatternCheckBox.setSelected(basicStyle.isRenderingLinePattern());
        this.fillPatternCheckBox.setSelected(basicStyle.isRenderingFillPattern());
        this.linePatternComboBox.setSelectedItem(basicStyle.getLinePattern());
        this.updateFillPatternColors();
        this.fillPatternComboBox.setSelectedItem(this.findEquivalentItem(basicStyle.getFillPattern(), this.fillPatternComboBox));
        this.updateControls();
    }

    private void addCustomFillPatterns() {
        Iterator i = ((Collection)this.blackboard.get(FillPatternFactory.CUSTOM_FILL_PATTERNS_KEY, new ArrayList())).iterator();
        while (i.hasNext()) {
            Paint fillPattern = (Paint)i.next();
            if (null != this.findEquivalentItem(fillPattern, this.fillPatternComboBox)) continue;
            ((DefaultComboBoxModel)this.fillPatternComboBox.getModel()).addElement(this.cloneIfBasicFillPattern(fillPattern));
        }
    }

    private Object findEquivalentItem(Object item, JComboBox comboBox) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (!item.equals(comboBox.getItemAt(i))) continue;
            return comboBox.getItemAt(i);
        }
        return null;
    }

    public BasicStyle getBasicStyle() {
        BasicStyle basicStyle = new BasicStyle();
        basicStyle.setFillColor(this.fillColorChooserPanel.getColor());
        basicStyle.setLineColor(this.lineColorChooserPanel.getColor());
        basicStyle.setAlpha(this.getAlpha());
        basicStyle.setRenderingFill(this.fillCheckBox.isSelected());
        basicStyle.setRenderingLine(this.lineCheckBox.isSelected());
        basicStyle.setRenderingLinePattern(this.linePatternCheckBox.isSelected());
        basicStyle.setRenderingFillPattern(this.fillPatternCheckBox.isSelected());
        basicStyle.setLinePattern(this.clean((String)this.linePatternComboBox.getEditor().getItem()));
        basicStyle.setFillPattern(this.cloneIfBasicFillPattern((Paint)this.fillPatternComboBox.getSelectedItem()));
        basicStyle.setLineWidth(this.lineWidthSlider.getValue());
        return basicStyle;
    }

    private Paint cloneIfBasicFillPattern(Paint fillPattern) {
        return fillPattern instanceof BasicFillPattern ? (Paint)((BasicFillPattern)fillPattern).clone() : fillPattern;
    }

    protected void setFillColor(Color newColor) {
        this.fillColorChooserPanel.setColor(newColor);
        this.transparencyPanel.setColor(newColor);
    }

    protected void updateControls() {
        this.linePatternComboBox.setEnabled(this.linePatternCheckBox.isSelected());
        this.fillPatternComboBox.setEnabled(this.fillPatternCheckBox.isSelected());
        this.lineColorChooserPanel.setEnabled(this.lineCheckBox.isSelected());
        this.fillColorChooserPanel.setEnabled(this.fillCheckBox.isSelected());
        this.fillColorChooserPanel.setAlpha(this.getAlpha());
        this.lineColorChooserPanel.setAlpha(this.getAlpha());
        this.palettePanel.setAlpha(this.getAlpha());
        this.transparencyPanel.setColor(this.lineCheckBox.isSelected() && !this.fillCheckBox.isSelected() ? this.lineColorChooserPanel.getColor() : this.fillColorChooserPanel.getColor());
        this.updateFillPatternColors();
        this.fillPatternComboBox.repaint();
    }

    private void updateFillPatternColors() {
        for (int i = 0; i < this.fillPatternComboBox.getItemCount(); ++i) {
            if (!(this.fillPatternComboBox.getItemAt(i) instanceof BasicFillPattern)) continue;
            ((BasicFillPattern)this.fillPatternComboBox.getItemAt(i)).setColor(GUIUtil.alphaColor(this.fillColorChooserPanel.getColor(), this.getAlpha()));
        }
    }

    void fillCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void fillColorChooserPanel_actionPerformed(ActionEvent e) {
        if (this.synchronizeCheckBox.isSelected()) {
            this.syncLineColor();
        }
        this.updateControls();
    }

    private void syncLineColor() {
        this.lineColorChooserPanel.setColor(this.fillColorChooserPanel.getColor().darker());
    }

    void lineColorChooserPanel_actionPerformed(ActionEvent e) {
        if (this.synchronizeCheckBox.isSelected()) {
            this.fillColorChooserPanel.setColor(this.lineColorChooserPanel.getColor().brighter());
        }
        this.updateControls();
    }

    void lineCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    public void setSynchronizingLineColor(boolean newSynchronizingLineColor) {
        this.synchronizeCheckBox.setSelected(newSynchronizingLineColor);
    }

    protected void synchronizeCheckBox_actionPerformed(ActionEvent e) {
        if (this.synchronizeCheckBox.isSelected()) {
            this.syncLineColor();
        }
        this.updateControls();
    }

    public JCheckBox getSynchronizeCheckBox() {
        return this.synchronizeCheckBox;
    }

    void linePatternCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void fillPatternCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    static /* synthetic */ Paint[] access$600(BasicStylePanel x0) {
        return x0.fillPatterns;
    }
}

