/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ColorThemingStyle
implements Style {
    private BasicStyle defaultStyle;
    private Layer layer;
    private Map attributeValueToBasicStyleMap = new HashMap();
    private String attributeName;
    private boolean enabled = false;
    static /* synthetic */ Class class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorThemingStyle;

    public ColorThemingStyle() {
    }

    public void setAlpha(int alpha) {
        this.defaultStyle.setAlpha(alpha);
        Iterator i = this.attributeValueToBasicStyleMap.values().iterator();
        while (i.hasNext()) {
            BasicStyle style = (BasicStyle)i.next();
            style.setAlpha(alpha);
        }
    }

    public void setLineWidth(int lineWidth) {
        this.defaultStyle.setLineWidth(lineWidth);
        Iterator i = this.attributeValueToBasicStyleMap.values().iterator();
        while (i.hasNext()) {
            BasicStyle style = (BasicStyle)i.next();
            style.setLineWidth(lineWidth);
        }
    }

    public ColorThemingStyle(String attributeName, Map attributeValueToBasicStyleMap, BasicStyle defaultStyle) {
        this.setAttributeName(attributeName);
        this.setAttributeValueToBasicStyleMap(attributeValueToBasicStyleMap);
        this.setDefaultStyle(defaultStyle);
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        this.getStyle(f).paint(f, g, viewport);
    }

    private BasicStyle getStyle(Feature feature) {
        BasicStyle style = this.attributeName != null && feature.getSchema().hasAttribute(this.attributeName) && feature.getAttribute(this.attributeName) != null ? (BasicStyle)this.attributeValueToBasicStyleMap.get(ColorThemingStyle.trimIfString(feature.getAttribute(this.attributeName))) : this.defaultStyle;
        return style == null ? this.defaultStyle : style;
    }

    public static Object trimIfString(Object object) {
        return object != null && object instanceof String ? ((String)object).trim() : object;
    }

    public Object clone() {
        try {
            ColorThemingStyle clone = (ColorThemingStyle)super.clone();
            Map mapClone = (Map)this.attributeValueToBasicStyleMap.getClass().newInstance();
            Iterator i = this.attributeValueToBasicStyleMap.keySet().iterator();
            while (i.hasNext()) {
                Object attribute = i.next();
                mapClone.put(attribute, ((BasicStyle)this.attributeValueToBasicStyleMap.get(attribute)).clone());
            }
            clone.attributeValueToBasicStyleMap = mapClone;
            return clone;
        }
        catch (InstantiationException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
        catch (IllegalAccessException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeValueToBasicStyleMap(Map attributeValueToStyleMap) {
        this.attributeValueToBasicStyleMap = attributeValueToStyleMap;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Map getAttributeValueToBasicStyleMap() {
        return this.attributeValueToBasicStyleMap;
    }

    public void initialize(Layer layer) {
        this.layer = layer;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static ColorThemingStyle get(Layer layer) {
        if ((ColorThemingStyle)layer.getStyle(class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorThemingStyle == null ? (class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorThemingStyle = ColorThemingStyle.class$("com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle")) : class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorThemingStyle) == null) {
            ColorThemingStyle colorThemingStyle = new ColorThemingStyle(ColorThemingStyle.pickNonSpatialAttributeName(layer.getFeatureCollectionWrapper().getFeatureSchema()), new HashMap(), new BasicStyle(Color.lightGray));
            layer.addStyle(colorThemingStyle);
        }
        return (ColorThemingStyle)layer.getStyle(class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorThemingStyle == null ? (class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorThemingStyle = ColorThemingStyle.class$("com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle")) : class$com$vividsolutions$jump$workbench$ui$renderer$style$ColorThemingStyle);
    }

    private static String pickNonSpatialAttributeName(FeatureSchema schema) {
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getGeometryIndex() == i) continue;
            return schema.getAttributeName(i);
        }
        return null;
    }

    public BasicStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(BasicStyle defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

